/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.model;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.examples.logicdesigner.model.AndGate;
import org.eclipse.gef.examples.logicdesigner.model.Circuit;
import org.eclipse.gef.examples.logicdesigner.model.Gate;
import org.eclipse.gef.examples.logicdesigner.model.GroundOutput;
import org.eclipse.gef.examples.logicdesigner.model.LED;
import org.eclipse.gef.examples.logicdesigner.model.LiveOutput;
import org.eclipse.gef.examples.logicdesigner.model.LogicFlowContainer;
import org.eclipse.gef.examples.logicdesigner.model.LogicLabel;
import org.eclipse.gef.examples.logicdesigner.model.LogicSubpart;
import org.eclipse.gef.examples.logicdesigner.model.OrGate;
import org.eclipse.gef.examples.logicdesigner.model.SimpleOutput;
import org.eclipse.gef.examples.logicdesigner.model.Wire;
import org.eclipse.gef.examples.logicdesigner.model.XORGate;
import org.eclipse.gef.requests.CreationFactory;

public class LogicElementFactory
implements CreationFactory {
    private String template;

    public LogicElementFactory(String str) {
        this.template = str;
    }

    protected void connect(LogicSubpart part1, String conn1, LogicSubpart part2, String conn2) {
        Wire wire = new Wire();
        wire.setSource(part1);
        wire.setSourceTerminal(conn1);
        wire.setTarget(part2);
        wire.setTargetTerminal(conn2);
        wire.attachSource();
        wire.attachTarget();
    }

    public Circuit createFullAdder() {
        Circuit circuit1 = this.createHalfAdder();
        Circuit circuit2 = this.createHalfAdder();
        circuit1.setLocation(new Point(2, 10));
        circuit2.setLocation(new Point(38, 90));
        Circuit circuit = new Circuit();
        circuit.setSize(new Dimension(120, 216));
        OrGate or = new OrGate();
        or.setLocation(new Point(22, 162));
        circuit.addChild(circuit1);
        circuit.addChild(circuit2);
        this.connect(circuit, Circuit.TERMINALS_OUT[0], circuit1, Circuit.TERMINALS_IN[0]);
        this.connect(circuit, Circuit.TERMINALS_OUT[2], circuit1, Circuit.TERMINALS_IN[3]);
        this.connect(circuit, Circuit.TERMINALS_OUT[3], circuit2, Circuit.TERMINALS_IN[3]);
        this.connect(circuit1, Circuit.TERMINALS_OUT[7], circuit2, Circuit.TERMINALS_IN[0]);
        circuit.addChild(or);
        this.connect(or, SimpleOutput.TERMINAL_OUT, circuit, Circuit.TERMINALS_IN[4]);
        this.connect(circuit1, Circuit.TERMINALS_OUT[4], or, Gate.TERMINAL_A);
        this.connect(circuit2, Circuit.TERMINALS_OUT[4], or, Gate.TERMINAL_B);
        this.connect(circuit2, Circuit.TERMINALS_OUT[7], circuit, Circuit.TERMINALS_IN[7]);
        return circuit;
    }

    public Circuit createHalfAdder() {
        Circuit circuit = new Circuit();
        circuit.setSize(new Dimension(60, 70));
        AndGate and = new AndGate();
        and.setLocation(new Point(2, 12));
        XORGate xor = new XORGate();
        xor.setLocation(new Point(22, 12));
        circuit.addChild(xor);
        circuit.addChild(and);
        this.connect(circuit, Circuit.TERMINALS_OUT[0], and, Gate.TERMINAL_A);
        this.connect(circuit, Circuit.TERMINALS_OUT[3], and, Gate.TERMINAL_B);
        this.connect(circuit, Circuit.TERMINALS_OUT[0], xor, Gate.TERMINAL_A);
        this.connect(circuit, Circuit.TERMINALS_OUT[3], xor, Gate.TERMINAL_B);
        this.connect(and, SimpleOutput.TERMINAL_OUT, circuit, Circuit.TERMINALS_IN[4]);
        this.connect(xor, SimpleOutput.TERMINAL_OUT, circuit, Circuit.TERMINALS_IN[7]);
        return circuit;
    }

    public Object getNewObject() {
        if ("and gate template".equals(this.template)) {
            return new AndGate();
        }
        if ("circuit template".equals(this.template)) {
            return new Circuit();
        }
        if ("flow container template".equals(this.template)) {
            return new LogicFlowContainer();
        }
        if ("full adder template".equals(this.template)) {
            return this.createFullAdder();
        }
        if ("ground template".equals(this.template)) {
            return new GroundOutput();
        }
        if ("half adder template".equals(this.template)) {
            return this.createHalfAdder();
        }
        if ("led template".equals(this.template)) {
            return new LED();
        }
        if ("live output template".equals(this.template)) {
            return new LiveOutput();
        }
        if ("logic label template".equals(this.template)) {
            return new LogicLabel();
        }
        if ("or gate template".equals(this.template)) {
            return new OrGate();
        }
        if ("xor gate template".equals(this.template)) {
            return new XORGate();
        }
        return null;
    }

    public Object getObjectType() {
        return this.template;
    }
}

