/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.pde;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.XYAnchor;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.internal.graph.NodePair;
import org.eclipse.gef.examples.pde.AbstractGraphDemo;

public class DirectedGraphDemo
extends AbstractGraphDemo {
    public static Figure buildGraph(DirectedGraph graph) {
        Panel contents = new Panel();
        contents.setBackgroundColor(ColorConstants.white);
        contents.setLayoutManager((LayoutManager)new XYLayout());
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = graph.nodes.getNode(i);
            AbstractGraphDemo.buildNodeFigure((Figure)contents, node);
            ++i;
        }
        i = 0;
        while (i < graph.edges.size()) {
            Edge edge = graph.edges.getEdge(i);
            AbstractGraphDemo.buildEdgeFigure((Figure)contents, edge);
            ++i;
        }
        if (AbstractGraphDemo.buildPrime) {
            DirectedGraphDemo.buildPrimeGraph(graph.gPrime, (Figure)contents);
        }
        return contents;
    }

    public static void buildPrimeGraph(DirectedGraph graph, Figure panel) {
        int i = 0;
        while (i < graph.edges.size()) {
            Node n1;
            Edge e = graph.edges.getEdge(i);
            PolylineConnection line = new PolylineConnection();
            if (e.tree) {
                PolygonDecoration dec = new PolygonDecoration();
                dec.setLineWidth(2);
                line.setLineWidth(3);
                Label l = new Label(String.valueOf(e.cut) + "," + e.getSlack());
                l.setOpaque(true);
                line.add((IFigure)l, (Object)new ConnectionLocator((Connection)line));
            } else {
                line.setLineStyle(3);
            }
            panel.add((IFigure)line);
            Node n2 = (Node)e.target.data;
            if (e.source.data instanceof NodePair) {
                NodePair pair = (NodePair)e.source.data;
                n1 = pair.n1;
                if (n1 == n2) {
                    n1 = pair.n2;
                }
            } else {
                n1 = (Node)e.source.data;
            }
            Object sa = new XYAnchor(new Point(n1.x, n1.y + 20));
            Object ta = new XYAnchor(new Point(n2.x, n2.y + 20));
            if (n1.rank == n2.rank) {
                if (n1.data instanceof Figure) {
                    sa = new AbstractGraphDemo.TopOrBottomAnchor((IFigure)((Figure)n1.data));
                }
                if (n2.data instanceof Figure) {
                    ta = new AbstractGraphDemo.TopOrBottomAnchor((IFigure)((Figure)n2.data));
                }
            } else {
                sa = new XYAnchor(new Point((n1.x + n2.x) / 2 - 15, (n1.y + n2.y) / 2 + 20));
                if (n2.data instanceof Figure) {
                    ta = new AbstractGraphDemo.TopOrBottomAnchor((IFigure)((Figure)n2.data));
                }
            }
            line.setSourceAnchor((ConnectionAnchor)sa);
            line.setTargetAnchor((ConnectionAnchor)ta);
            ++i;
        }
    }
}

