/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.hibernate.eclipse.logging.xpl.EclipseLogger;
import org.osgi.framework.BundleContext;

public class MapperPlugin
extends AbstractUIPlugin {
    public static final String ID = MapperPlugin.class.getName();
    private static MapperPlugin plugin;
    private ResourceBundle resourceBundle;
    private EclipseLogger logger;

    public MapperPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.logger = new EclipseLogger(context.getBundle());
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        this.resourceBundle = null;
    }

    public static MapperPlugin getDefault() {
        return plugin;
    }

    public EclipseLogger getLogger() {
        return this.logger;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MapperPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.hibernate.eclipse.mapper.MapperPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public void logException(Throwable exception) {
        this.getLogger().logException(exception);
    }
}

