/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.hibernate.eclipse.console.model.IRevEngColumn;
import org.hibernate.eclipse.mapper.editors.reveng.FormTextEntryListenerAdapter;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.xpl.FormTextEntry;

public class ColumnDetailsPage
extends RevEngDetailsPage
implements IDetailsPage,
PropertyChangeListener {
    private Button excluded;
    private FormTextEntry nameEntry;
    private FormTextEntry jdbcTypeEntry;
    private FormTextEntry propertyEntry;
    private FormTextEntry typeEntry;
    private IRevEngColumn column;

    public void buildContents(FormToolkit toolkit, Section section, Composite client) {
        section.setText("Column Details");
        section.setDescription("Set the properties of the selected column.");
        this.nameEntry = new FormTextEntry(client, toolkit, "Name:", 0);
        this.nameEntry.setDescription("The name of the column");
        this.nameEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ColumnDetailsPage.this.column.setName(entry.getValue());
            }
        });
        this.excluded = toolkit.createButton(client, "Exclude column from reverse engineering", 32);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 3;
        this.excluded.setLayoutData((Object)gridData);
        this.excluded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnDetailsPage.this.column.setExcluded(ColumnDetailsPage.this.excluded.getSelection());
            }
        });
        this.jdbcTypeEntry = new FormTextEntry(client, toolkit, "JDBC Type:", 0);
        this.jdbcTypeEntry.setDescription("Which JDBC Type this column should have (overriding the type read from the database)");
        this.jdbcTypeEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ColumnDetailsPage.this.column.setJDBCType(entry.getValue());
            }
        });
        this.propertyEntry = new FormTextEntry(client, toolkit, "Property name:", 0);
        this.propertyEntry.setDescription("The property name which must be used for this column when used as a property");
        this.propertyEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ColumnDetailsPage.this.column.setPropertyName(entry.getValue());
            }
        });
        this.typeEntry = new FormTextEntry(client, toolkit, "Hibernate Type:", 0);
        this.typeEntry.setDescription("The hibernate type which should be used for this colum when used as a property");
        this.typeEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                ColumnDetailsPage.this.column.setType(entry.getValue());
            }
        });
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IRevEngColumn newColumn = (IRevEngColumn)((IStructuredSelection)selection).getFirstElement();
        if (this.column != null) {
            this.column.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (newColumn != null) {
            newColumn.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.column = newColumn;
        this.update();
    }

    private void update() {
        this.nameEntry.setValue(this.column.getName());
        this.jdbcTypeEntry.setValue(this.column.getJDBCType());
        this.propertyEntry.setValue(this.column.getPropertyName());
        this.typeEntry.setValue(this.column.getType());
        this.excluded.setSelection(this.column.getExclude());
        this.nameEntry.setEditable(!this.column.getExclude());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }
}

