/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.model;

import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.hibernate.eclipse.console.model.ITypeMapping;
import org.hibernate.eclipse.mapper.model.DOMAdapter;
import org.hibernate.eclipse.mapper.model.DOMReverseEngineeringDefinition;
import org.w3c.dom.Node;

public class TypeMappingAdapter
extends DOMAdapter
implements ITypeMapping {
    public TypeMappingAdapter(Node node, DOMReverseEngineeringDefinition model) {
        super(node, model);
    }

    public String getJDBCType() {
        Node type = this.getNode().getAttributes().getNamedItem("jdbc-type");
        return type == null ? null : type.getNodeValue();
    }

    public String getHibernateType() {
        Node type = this.getNode().getAttributes().getNamedItem("hibernate-type");
        return type == null ? null : type.getNodeValue();
    }

    public Integer getLength() {
        String name = "length";
        return this.getInteger(name);
    }

    public Boolean getNullable() {
        return this.getBoolean("not-null");
    }

    private Integer getInteger(String name) {
        Node type = this.getNode().getAttributes().getNamedItem(name);
        if (type == null) {
            return null;
        }
        try {
            Integer decode = Integer.decode(type.getNodeValue());
            return decode;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private Boolean getBoolean(String name) {
        Node type = this.getNode().getAttributes().getNamedItem(name);
        if (type == null) {
            return null;
        }
        Boolean decode = Boolean.valueOf(type.getNodeValue());
        return decode;
    }

    public Integer getPrecision() {
        return this.getInteger("precision");
    }

    public Integer getScale() {
        return this.getInteger("scale");
    }

    public void setJDBCType(String string) {
        this.setAttribute("jdbc-type", string, null);
    }

    public void setLength(Integer length) {
        this.setAttribute("length", length == null ? null : length.toString(), null);
    }

    public void setHibernateType(String type) {
        this.setAttribute("hibernate-type", type, "");
    }

    public void setPrecision(Integer precision) {
        this.setAttribute("precision", precision == null ? null : precision.toString(), null);
    }

    public void setScale(Integer scale) {
        this.setAttribute("scale", scale == null ? null : scale.toString(), null);
    }

    public void setNullable(Boolean value) {
        this.setAttribute("not-null", value == null ? null : value.toString(), null);
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        this.getModel().sqlTypeChanged(notifier);
    }
}

