/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.views.contentoutline;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.ui.views.contentoutline.XMLContentOutlineConfiguration;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.w3c.dom.Node;

public class HibernateXMLContentOutlineConfiguration
extends XMLContentOutlineConfiguration {
    private HibernateToolsLabelProvider labelProvider;

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.labelProvider == null) {
            this.labelProvider = new HibernateToolsLabelProvider(super.getLabelProvider(viewer));
        }
        return this.labelProvider;
    }

    static class HibernateToolsLabelProvider
    implements ILabelProvider {
        ILabelProvider delegate;
        static Map nameToMap = new HashMap();

        static {
            nameToMap.put("many-to-one", "MANYTOONE");
            nameToMap.put("one-to-many", "ONETOMANY");
            nameToMap.put("property", "PROPERTY");
            nameToMap.put("class", "MAPPEDCLASS");
            nameToMap.put("subclass", "MAPPEDCLASS");
            nameToMap.put("joined-subclass", "MAPPEDCLASS");
            nameToMap.put("union-subclass", "MAPPEDCLASS");
            nameToMap.put("id", "IDPROPERTY");
            nameToMap.put("one-to-one", "ONETOONE");
            nameToMap.put("component", "ONETOONE");
        }

        public HibernateToolsLabelProvider(ILabelProvider labelProvider) {
            this.delegate = labelProvider;
        }

        public void addListener(ILabelProviderListener listener) {
            this.delegate.addListener(listener);
        }

        public void dispose() {
            this.delegate.dispose();
        }

        public Image getImage(Object element) {
            String key;
            Node node = (Node)element;
            if (node.getNodeType() == 1 && (key = (String)nameToMap.get(node.getNodeName())) != null) {
                return EclipseImages.getImage((String)key);
            }
            return this.delegate.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof Node) {
                Node node = (Node)element;
                String nodeName = node.getNodeName();
                if (node.getNodeType() == 7 && "xml".equals(nodeName)) {
                    return "xml (Hibernate Tools)";
                }
            }
            return this.delegate.getText(element);
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.delegate.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.delegate.removeListener(listener);
        }
    }
}

