/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.eclipse.core.runtime.ILog;
import org.eclipse.ui.console.MessageConsoleStream;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.logging.CurrentContext;

public class PluginLogAppender
extends AppenderSkeleton {
    private ILog pluginLog;
    private Map streams = new HashMap();

    void setLog(ILog pluginLog) {
        this.pluginLog = pluginLog;
    }

    public void append(LoggingEvent event) {
        ThrowableInformation info;
        if (this.layout == null) {
            this.errorHandler.error("Missing layout for appender " + this.name, null, 5);
            return;
        }
        String text = this.layout.format(event);
        Throwable thrown = null;
        if (this.layout.ignoresThrowable() && (info = event.getThrowableInformation()) != null) {
            thrown = info.getThrowable();
        }
        Object peek = CurrentContext.peek();
        MessageConsoleStream stream = KnownConfigurations.getInstance().findLoggingStream((String)peek);
        if (stream != null) {
            stream.println(text);
            if (thrown != null) {
                StringWriter stringWriter = new StringWriter();
                thrown.printStackTrace(new PrintWriter(stringWriter));
                stream.println(stringWriter.getBuffer().toString());
            }
        }
    }

    public void close() {
        this.closed = true;
    }

    public boolean requiresLayout() {
        return true;
    }
}

