/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adapt;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.jgroups.tests.adapt.JGroupsTester;

public class Test {
    public static void main(String[] args) {
        String config = "config.txt";
        boolean sender = false;
        int num_msgs = 1000;
        int msg_size = 500;
        int grpMembers = 4;
        int num_senders = 1;
        String props = null;
        long log_interval = 1000L;
        for (int i = 0; i < args.length; ++i) {
            if ("-sender".equals(args[i])) {
                sender = true;
                continue;
            }
            if ("-receiver".equals(args[i])) {
                sender = false;
                continue;
            }
            if ("-config".equals(args[i])) {
                config = args[++i];
                continue;
            }
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            Test.help();
            return;
        }
        try {
            String line;
            BufferedReader fileReader = new BufferedReader(new FileReader(config));
            while ((line = fileReader.readLine()) != null) {
                String gnuplot_output;
                if (line.startsWith("#")) continue;
                if (line.startsWith("NUM_MSGS=")) {
                    num_msgs = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("MSG_SIZE=")) {
                    msg_size = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("GRPMEMBERS=")) {
                    grpMembers = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("NUM_SENDERS=")) {
                    num_senders = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("LOG_INTERVAL=")) {
                    log_interval = Long.parseLong(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("PROPS=")) {
                    if (props == null) {
                        props = line.substring(line.indexOf(61) + 1, line.indexOf(59)).trim();
                        continue;
                    }
                    System.out.println("-- properties " + props + " given on command line override file properies");
                    continue;
                }
                if (!line.startsWith("GNUPLOT_OUTPUT=") || System.getProperty("gnuplot_output") != null || (gnuplot_output = line.substring(line.indexOf(61) + 1, line.indexOf(59)).trim()) == null) continue;
                System.setProperty("gnuplot_output", gnuplot_output);
            }
            fileReader.close();
            System.out.println("Javagroups test:");
            String s = "Initial params parsing completed. Starting test with these values:\nSender:" + sender + "  num_msgs:" + num_msgs + "  Size(bytes):" + msg_size + "  # Mbrs:" + grpMembers + "  Senders: " + num_senders + "\nLog interval: " + log_interval + '\n';
            System.out.println(s);
            Logger.getLogger((Class)Test.class).info((Object)("main(): " + s));
            new JGroupsTester(sender, num_msgs, msg_size, grpMembers, num_senders, props, log_interval).initialize();
        }
        catch (FileNotFoundException notFound) {
            System.err.println("File not found.\n" + notFound);
        }
        catch (IOException ioError) {
            ioError.printStackTrace();
        }
    }

    static void help() {
        System.out.println("Test [-help] ([-sender] | [-receiver]) [-config <config file>] [-props <stack config>]");
    }
}

