/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adaptjms;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.net.DatagramPacket;
import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.log4j.Logger;
import org.jgroups.tests.adaptjms.Request;

public class ReceiverThread
implements MessageListener {
    private int msg_size;
    private int num_senders;
    private long expected_msgs;
    Logger log = Logger.getLogger(this.getClass());
    long counter = 1L;
    long beginning = 0L;
    long ending = 0L;
    long elapsed_time;
    long last_dump;
    long log_interval = 1000L;
    boolean gnuplot_output = Boolean.getBoolean("gnuplot_output");
    TopicSession session;
    List receivers = new ArrayList();
    Object counter_mutex = new Object();
    boolean started = false;
    double throughput_s;
    double throughput_b;
    boolean done = false;
    Request req;
    byte[] buf = new byte[300000];
    DatagramPacket p = new DatagramPacket(this.buf, this.buf.length);
    ByteArrayInputStream input;
    ObjectInputStream in;

    public ReceiverThread(TopicSession session, Topic topic, int num_msgs, int ms, int ns, long log_interval) throws JMSException {
        this.msg_size = ms;
        this.num_senders = ns;
        this.expected_msgs = num_msgs * this.num_senders;
        this.log_interval = log_interval;
        this.session = session;
        TopicSubscriber sub = session.createSubscriber(topic);
        sub.setMessageListener((MessageListener)this);
    }

    public void start() {
        System.out.println("\nReceiver started...\n");
        this.counter = 1L;
        this.beginning = 0L;
        this.ending = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        if (this.done) {
            return;
        }
        if (message instanceof ObjectMessage) {
            Request req = (Request)message;
            if (req.type != 3) {
                return;
            }
            Object object = this.counter_mutex;
            synchronized (object) {
                if (this.counter == 1L && !this.started) {
                    this.last_dump = this.beginning = System.currentTimeMillis();
                    this.started = true;
                }
                ++this.counter;
                if (this.counter % 100L == 0L) {
                    System.out.println("-- received " + this.counter + " msgs");
                }
                if (this.counter % this.log_interval == 0L && this.log.isInfoEnabled()) {
                    this.log.info((Object)this.dumpStats(this.counter));
                }
                if (this.counter >= this.expected_msgs && !this.done) {
                    this.ending = System.currentTimeMillis();
                    this.done = true;
                }
            }
            if (this.counter >= this.expected_msgs) {
                this.done = true;
                if (this.gnuplot_output) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("\n##### msgs_received");
                    sb.append(", free_mem [KB] ");
                    sb.append(", total_mem [KB] ");
                    sb.append(", total_msgs_sec [msgs/sec] ");
                    sb.append(", total_throughput [KB/sec] ");
                    sb.append(", rolling_msgs_sec (last ").append(this.log_interval).append(" msgs) ");
                    sb.append(" [msgs/sec] ");
                    sb.append(", rolling_throughput (last ").append(this.log_interval).append(" msgs) ");
                    sb.append(" [KB/sec]\n");
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)sb.toString());
                    }
                }
                this.elapsed_time = this.ending - this.beginning;
                System.out.println("expected_msgs=" + this.expected_msgs + ", elapsed_time=" + this.elapsed_time);
                this.throughput_s = (double)this.expected_msgs / ((double)this.elapsed_time / 1000.0);
                this.throughput_b = (double)this.expected_msgs * ((double)this.msg_size / 1000.0) / ((double)this.elapsed_time / 1000.0);
                String result = "Received " + this.expected_msgs + " msgs. in " + this.elapsed_time + " msec.\n" + "Throughput: " + this.throughput_s + " [msgs/sec]\n" + "Throughput: " + this.throughput_b + " [KB/sec]\n" + "Total received: " + (double)this.expected_msgs * ((double)this.msg_size / 1000.0 / 1000.0) + " [MB]\n";
                System.out.println(result);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)result);
                }
            }
        }
    }

    String dumpStats(long received_msgs) {
        StringBuffer sb = new StringBuffer();
        if (this.gnuplot_output) {
            sb.append(received_msgs).append(' ');
        } else {
            sb.append("\nmsgs_received=").append(received_msgs);
        }
        if (this.gnuplot_output) {
            sb.append((double)Runtime.getRuntime().freeMemory() / 1000.0).append(' ');
        } else {
            sb.append(", free_mem=").append((double)Runtime.getRuntime().freeMemory() / 1000.0);
        }
        if (this.gnuplot_output) {
            sb.append((double)Runtime.getRuntime().totalMemory() / 1000.0).append(' ');
        } else {
            sb.append(", total_mem=").append((double)Runtime.getRuntime().totalMemory() / 1000.0).append('\n');
        }
        this.dumpThroughput(sb, received_msgs);
        return sb.toString();
    }

    void dumpThroughput(StringBuffer sb, long received_msgs) {
        long current = System.currentTimeMillis();
        double tmp = 1000L * this.counter / (current - this.beginning);
        if (this.gnuplot_output) {
            sb.append(tmp).append(' ');
        } else {
            sb.append("total_msgs_sec=").append(tmp).append(" [msgs/sec]");
        }
        tmp = received_msgs * (long)this.msg_size / (current - this.beginning);
        if (this.gnuplot_output) {
            sb.append(tmp).append(' ');
        } else {
            sb.append("\ntotal_throughput=").append(tmp).append(" [KB/sec]");
        }
        tmp = 1000L * this.log_interval / (current - this.last_dump);
        if (this.gnuplot_output) {
            sb.append(tmp).append(' ');
        } else {
            sb.append("\nrolling_msgs_sec (last ").append(this.log_interval).append(" msgs)=");
            sb.append(tmp).append(" [msgs/sec]");
        }
        tmp = this.log_interval * (long)this.msg_size / (current - this.last_dump);
        if (this.gnuplot_output) {
            sb.append(tmp).append(' ');
        } else {
            sb.append("\nrolling_throughput (last ").append(this.log_interval).append(" msgs)=");
            sb.append(tmp).append(" [KB/sec]\n");
        }
        this.last_dump = current;
    }
}

