/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;

public class Data
implements Externalizable {
    static final int DISCOVERY_REQ = 1;
    static final int DISCOVERY_RSP = 2;
    static final int DATA = 3;
    static final int DONE = 4;
    static final int RESULTS = 5;
    int type = 0;
    byte[] payload = null;
    boolean sender = false;
    long num_msgs = 0L;
    HashMap results = null;

    public Data() {
    }

    public Data(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.type);
        if (this.payload != null) {
            out.writeInt(this.payload.length);
            out.write(this.payload, 0, this.payload.length);
        } else {
            out.writeInt(0);
        }
        out.writeBoolean(this.sender);
        out.writeLong(this.num_msgs);
        if (this.results != null) {
            out.writeBoolean(true);
            out.writeObject(this.results);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readInt();
        int len = in.readInt();
        if (len > 0) {
            this.payload = new byte[len];
            in.readFully(this.payload, 0, this.payload.length);
        }
        this.sender = in.readBoolean();
        this.num_msgs = in.readLong();
        boolean results_available = in.readBoolean();
        if (results_available) {
            this.results = (HashMap)in.readObject();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        switch (this.type) {
            case 1: {
                sb.append("DISCOVERY_REQ");
                break;
            }
            case 2: {
                sb.append("DISCOVERY_RSP");
                break;
            }
            case 3: {
                sb.append("DATA");
                break;
            }
            case 4: {
                sb.append("DONE");
                break;
            }
            case 5: {
                sb.append("RESULTS");
                break;
            }
            default: {
                sb.append("<unknown>");
            }
        }
        sb.append("] ");
        return sb.toString();
    }
}

