/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedBoolean
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected boolean value_;

    public SynchronizedBoolean(boolean initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedBoolean(boolean initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public final boolean get() {
        Object object = this.lock_;
        synchronized (object) {
            boolean bl = this.value_;
            return bl;
        }
    }

    public boolean set(boolean newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean old = this.value_;
            this.value_ = newValue;
            boolean bl = old;
            return bl;
        }
    }

    public boolean commit(boolean assumedValue, boolean newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success;
            boolean bl = success = assumedValue == this.value_;
            if (success) {
                this.value_ = newValue;
            }
            boolean bl2 = success;
            return bl2;
        }
    }

    public boolean swap(SynchronizedBoolean other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedBoolean fst = this;
        SynchronizedBoolean snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            Object object2 = snd.lock_;
            synchronized (object2) {
                fst.set(snd.set(fst.get()));
                boolean bl = this.get();
                return bl;
            }
        }
    }

    public boolean complement() {
        Object object = this.lock_;
        synchronized (object) {
            boolean bl = this.value_ = !this.value_;
            return bl;
        }
    }

    public boolean and(boolean b) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ &= b;
            boolean bl = this.value_;
            return bl;
        }
    }

    public boolean or(boolean b) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ |= b;
            boolean bl = this.value_;
            return bl;
        }
    }

    public boolean xor(boolean b) {
        Object object = this.lock_;
        synchronized (object) {
            this.value_ ^= b;
            boolean bl = this.value_;
            return bl;
        }
    }

    public int compareTo(boolean other) {
        boolean val = this.get();
        return val == other ? 0 : (val ? 1 : -1);
    }

    public int compareTo(SynchronizedBoolean other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedBoolean)other);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedBoolean) {
            return this.get() == ((SynchronizedBoolean)other).get();
        }
        return false;
    }

    public int hashCode() {
        boolean b = this.get();
        return b ? 3412688 : 8319343;
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

