/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug.impl;

import freemarker.core.Environment;
import freemarker.debug.impl.RmiDebuggerService;
import freemarker.template.Template;
import freemarker.template.utility.SecurityUtilities;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;

public abstract class DebuggerService {
    private static final DebuggerService instance = DebuggerService.createInstance();

    private static DebuggerService createInstance() {
        return SecurityUtilities.getSystemProperty("freemarker.debug.password") == null ? new NoOpDebuggerService() : new RmiDebuggerService();
    }

    public static List getBreakpoints(String templateName) {
        return instance.getBreakpointsSpi(templateName);
    }

    abstract List getBreakpointsSpi(String var1);

    public static void registerTemplate(Template template) {
        instance.registerTemplateSpi(template);
    }

    abstract void registerTemplateSpi(Template var1);

    public static boolean suspendEnvironment(Environment env, int line) throws RemoteException {
        return instance.suspendEnvironmentSpi(env, line);
    }

    abstract boolean suspendEnvironmentSpi(Environment var1, int var2) throws RemoteException;

    private static class NoOpDebuggerService
    extends DebuggerService {
        private NoOpDebuggerService() {
        }

        List getBreakpointsSpi(String templateName) {
            return Collections.EMPTY_LIST;
        }

        boolean suspendEnvironmentSpi(Environment env, int line) {
            throw new UnsupportedOperationException();
        }

        void registerTemplateSpi(Template template) {
        }
    }
}

