/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding.metadata;

import org.jboss.xml.binding.metadata.JavaValue;
import org.jboss.xml.binding.metadata.XmlAttribute;
import org.jboss.xml.binding.metadata.XmlNamespace;
import org.jboss.xml.binding.metadata.XmlType;

public class XmlAttributeImpl
implements XmlAttribute {
    private final XmlNamespace ns;
    private final String name;
    private final XmlType type;
    private final JavaValue javaValue;

    public XmlAttributeImpl(XmlNamespace ns, String name, XmlType type) {
        this.ns = ns;
        this.name = name;
        this.type = type;
        this.javaValue = (JavaValue)type.getJavaValue().clone();
    }

    public XmlNamespace getNamespace() {
        return this.ns;
    }

    public String getName() {
        return this.name;
    }

    public XmlType getType() {
        return this.type;
    }

    public JavaValue getJavaValue() {
        return this.javaValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlAttributeImpl)) {
            return false;
        }
        XmlAttributeImpl xmlAttribute = (XmlAttributeImpl)o;
        if (!this.name.equals(xmlAttribute.name)) {
            return false;
        }
        return this.ns.equals(xmlAttribute.ns);
    }

    public int hashCode() {
        int result = this.ns.hashCode();
        result = 29 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "[attribute " + this.ns.getNamespaceUri() + ":" + this.name + "]";
    }
}

