/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding.metadata;

import org.jboss.xml.binding.metadata.JavaValue;
import org.jboss.xml.binding.metadata.XmlElement;
import org.jboss.xml.binding.metadata.XmlNamespace;
import org.jboss.xml.binding.metadata.XmlType;

public class XmlElementImpl
implements XmlElement {
    private final XmlNamespace ns;
    private final String name;
    private final XmlType type;
    private final JavaValue javaValue;

    public XmlElementImpl(XmlNamespace ns, String name, XmlType type) {
        this.ns = ns;
        this.name = name;
        this.type = type;
        this.javaValue = (JavaValue)type.getJavaValue().clone();
    }

    public XmlNamespace getNamespace() {
        return this.ns;
    }

    public String getName() {
        return this.name;
    }

    public XmlType getType() {
        return this.type;
    }

    public JavaValue getJavaValue() {
        return this.javaValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlElementImpl)) {
            return false;
        }
        XmlElementImpl xmlElement = (XmlElementImpl)o;
        if (!this.name.equals(xmlElement.name)) {
            return false;
        }
        return this.ns.equals(xmlElement.ns);
    }

    public int hashCode() {
        int result = this.ns.hashCode();
        result = 29 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "[element " + this.ns.getNamespaceUri() + ":" + this.name + "]";
    }
}

