/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view.views;

import java.util.ResourceBundle;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdentifierBag;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.List;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UnionSubclass;
import org.jboss.tools.hibernate.ui.view.ViewPlugin;
import org.jboss.tools.hibernate.ui.view.views.HibernateUtils;

public class OrmModelImageVisitor
implements PersistentClassVisitor {
    private ResourceBundle BUNDLE = ViewPlugin.BUNDLE_IMAGE;

    public Object visitDatabaseTable(Table table) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.DatabaseTable"));
    }

    public Object visitDatabaseColumn(Column column) {
        if (column.isUnique()) {
            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.DatabaseUniqueKeyColumn"));
        }
        if (HibernateUtils.isPrimaryKey(column) && HibernateUtils.getTable(column) != null && HibernateUtils.isForeignKey(column)) {
            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.DatabasePrimaryForeignKeysColumn"));
        }
        if (HibernateUtils.isPrimaryKey(column)) {
            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.DatabasePrimaryKeyColumn"));
        }
        if (HibernateUtils.getTable(column) != null && HibernateUtils.isForeignKey(column)) {
            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.DatabaseForeignKeyColumn"));
        }
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.DatabaseColumn"));
    }

    public Object visitPersistentField(Property field) {
        if (field != null) {
            if (field.getPersistentClass() != null && field.getPersistentClass().getVersion() == field) {
                return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldSimple_version"));
            }
            if (field.getPersistentClass() != null && field.getPersistentClass().getIdentifierProperty() == field) {
                return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldSimple_id"));
            }
            if (field.getValue() != null) {
                if (field.getValue() instanceof OneToMany) {
                    return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldOne-to-many"));
                }
                if (field.getValue() instanceof OneToOne) {
                    return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldOne-to-one"));
                }
                if (field.getValue() instanceof ManyToOne) {
                    return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldMany-to-one"));
                }
                if (field.getValue() instanceof Any) {
                    return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldAny"));
                }
                try {
                    if (field.getType() != null && field.getType().isCollectionType()) {
                        if (field.getValue() instanceof PrimitiveArray) {
                            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.Collection_primitive_array"));
                        }
                        if (field.getValue() instanceof Array) {
                            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.Collection_array"));
                        }
                        if (field.getValue() instanceof List) {
                            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.Collection_list"));
                        }
                        if (field.getValue() instanceof Set) {
                            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.Collection_set"));
                        }
                        if (field.getValue() instanceof Map) {
                            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.Collection_map"));
                        }
                        if (field.getValue() instanceof Bag) {
                            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.Collection_bag"));
                        }
                        if (field.getValue() instanceof IdentifierBag) {
                            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.Collection_idbag"));
                        }
                        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.Collection"));
                    }
                }
                catch (Exception exception) {
                    return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldNot_mapped"));
                }
            }
            if ("parent".equals(field.getName())) {
                return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldParent"));
            }
        }
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldSimple"));
    }

    public Object visitManyToOneMapping(ManyToOne field) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldMany-to-many"));
    }

    public Object visitOneToManyMapping(OneToMany field) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldOne-to-many"));
    }

    public Object visitSimpleValueMapping(SimpleValue field) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldSimple"));
    }

    public Object visitAnyMapping(Any field) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldMany-to-any"));
    }

    public Object visitComponentMapping(Component mapping) {
        if (mapping != null) {
            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldComponent"));
        }
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldNot_mapped"));
    }

    public Object visitComponentKeyMapping(DependantValue mapping) {
        if (mapping.getTable().getIdentifierValue() == mapping) {
            return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldComponent_id"));
        }
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentFieldSimple"));
    }

    public Object accept(RootClass arg0) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentClass"));
    }

    public Object accept(UnionSubclass arg0) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentClass"));
    }

    public Object accept(SingleTableSubclass arg0) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentClass"));
    }

    public Object accept(JoinedSubclass arg0) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentClass"));
    }

    public Object accept(Subclass arg0) {
        return ViewPlugin.getImageDescriptor(this.BUNDLE.getString("OrmModelImageVisitor.PersistentClass"));
    }
}

