/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;

public class HQLProblem
extends CategorizedProblem
implements IProblem {
    private int startingOffset;
    private int endingOffset;
    private int line;
    private IFile resource;
    private final String msg;
    private final boolean isError;

    HQLProblem(String msg, boolean isError, IFile resource, int startingOffset, int endingOffset, int line) {
        this.msg = msg;
        this.isError = isError;
        this.startingOffset = startingOffset;
        this.endingOffset = endingOffset;
        this.line = line;
        this.resource = resource;
    }

    public int getID() {
        return 900;
    }

    public String[] getArguments() {
        return new String[0];
    }

    public String getMessage() {
        return this.msg;
    }

    public char[] getOriginatingFileName() {
        return this.resource.getName().toCharArray();
    }

    public int getSourceStart() {
        return this.startingOffset;
    }

    public int getSourceEnd() {
        return this.endingOffset;
    }

    public int getSourceLineNumber() {
        return this.line;
    }

    public void setSourceStart(int sourceStart) {
        this.startingOffset = sourceStart;
    }

    public void setSourceEnd(int sourceEnd) {
        this.endingOffset = sourceEnd;
    }

    public void setSourceLineNumber(int lineNumber) {
        this.line = lineNumber;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isWarning() {
        return !this.isError();
    }

    public int getCategoryID() {
        return 20;
    }

    public String getMarkerType() {
        return "org.hibernate.eclipse.jdt.ui.hqlsyntax.problem";
    }
}

