/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.ContentOutlinePage;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.PageBook;
import org.jboss.tools.hibernate.ui.veditor.editors.VisualEditor;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.TreePartFactory;

public class DiagramContentOutlinePage
extends ContentOutlinePage
implements IAdaptable {
    private GraphicalViewer graphicalViewer;
    private VisualEditor editor;
    private OrmDiagram ormDiagram;
    private SelectionSynchronizer selectionSynchronizer;
    private PageBook pageBook;
    private Control outline;
    private Canvas overview;
    private IAction showOutlineAction;
    private IAction showOverviewAction;
    static final int ID_OUTLINE = 0;
    static final int ID_OVERVIEW = 1;
    private Thumbnail thumbnail;
    IPageSite pSite;
    private DisposeListener disposeListener;
    Set listeners = new HashSet();

    public DiagramContentOutlinePage(EditPartViewer viewer) {
        super(viewer);
    }

    public void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    public void update(GraphicalViewer graphicalViewer) {
        if (this.graphicalViewer != null && this.graphicalViewer != graphicalViewer) {
            this.getSelectionSynchronizer().removeViewer((EditPartViewer)this.graphicalViewer);
            this.replaceSelectionChangedListeners(graphicalViewer);
            this.graphicalViewer = graphicalViewer;
            this.getSelectionSynchronizer().addViewer((EditPartViewer)graphicalViewer);
            this.initializeOverview();
        }
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    public void setSelectionSynchronizer(SelectionSynchronizer selectionSynchronizer) {
        this.selectionSynchronizer = selectionSynchronizer;
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return this.selectionSynchronizer;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.pSite = pageSite;
    }

    protected void configureOutlineViewer() {
        this.getViewer().setEditDomain((EditDomain)this.editor.getDefaultEditDomain());
        this.getViewer().setEditPartFactory((EditPartFactory)new TreePartFactory());
        IToolBarManager tbm = this.getSite().getActionBars().getToolBarManager();
        this.showOutlineAction = new Action(){

            public void run() {
                DiagramContentOutlinePage.this.showPage(0);
            }
        };
        this.showOutlineAction.setImageDescriptor(ImageDescriptor.createFromFile(VisualEditor.class, (String)"icons/outline.gif"));
        tbm.add(this.showOutlineAction);
        this.showOverviewAction = new Action(){

            public void run() {
                DiagramContentOutlinePage.this.showPage(1);
            }
        };
        this.showOverviewAction.setImageDescriptor(ImageDescriptor.createFromFile(VisualEditor.class, (String)"icons/overview.gif"));
        tbm.add(this.showOverviewAction);
        this.showPage(1);
    }

    public void createControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.outline = this.getViewer().createControl((Composite)this.pageBook);
        this.overview = new Canvas((Composite)this.pageBook, 0);
        this.pageBook.showPage(this.outline);
        this.configureOutlineViewer();
        this.hookOutlineViewer();
        this.initializeOutlineViewer();
    }

    public void dispose() {
        this.unhookOutlineViewer();
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
            this.thumbnail = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return null;
    }

    public Control getControl() {
        return this.pageBook;
    }

    protected void hookOutlineViewer() {
        this.getSelectionSynchronizer().addViewer(this.getViewer());
    }

    protected void initializeOutlineViewer() {
        this.setContents(this.getOrmDiagram());
    }

    protected void initializeOverview() {
        LightweightSystem lws = new LightweightSystem(this.overview);
        RootEditPart rep = this.getGraphicalViewer().getRootEditPart();
        if (rep instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            if (this.thumbnail != null) {
                this.thumbnail.deactivate();
            }
            this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            this.thumbnail.setBorder((Border)new MarginBorder(3));
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)this.thumbnail);
        }
    }

    public void setContents(Object contents) {
        this.getViewer().setContents(contents);
    }

    protected void showPage(int id) {
        if (id == 0) {
            this.showOutlineAction.setChecked(true);
            this.showOverviewAction.setChecked(false);
            this.pageBook.showPage(this.outline);
            if (this.thumbnail != null) {
                this.thumbnail.setVisible(false);
            }
        } else if (id == 1) {
            if (this.thumbnail == null) {
                this.initializeOverview();
            }
            this.showOutlineAction.setChecked(false);
            this.showOverviewAction.setChecked(true);
            this.pageBook.showPage((Control)this.overview);
            this.thumbnail.setVisible(true);
        }
    }

    protected void unhookOutlineViewer() {
        this.getSelectionSynchronizer().removeViewer(this.getViewer());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        super.addSelectionChangedListener(listener);
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        super.removeSelectionChangedListener(listener);
        this.listeners.remove(listener);
    }

    void replaceSelectionChangedListeners(GraphicalViewer graphicalViewer) {
        for (ISelectionChangedListener l : this.listeners) {
            this.getViewer().removeSelectionChangedListener(l);
            graphicalViewer.addSelectionChangedListener(l);
        }
    }

    public OrmDiagram getOrmDiagram() {
        return this.ormDiagram;
    }

    public void setOrmDiagram(OrmDiagram ormDiagram) {
        this.ormDiagram = ormDiagram;
    }

    public VisualEditor getEditor() {
        return this.editor;
    }

    public void setEditor(VisualEditor editor) {
        this.editor = editor;
    }
}

