/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.RootClass;
import org.jboss.tools.hibernate.ui.veditor.editors.DiagramContentOutlinePage;
import org.jboss.tools.hibernate.ui.veditor.editors.actions.AutoLayoutAction;
import org.jboss.tools.hibernate.ui.veditor.editors.actions.ExportImageAction;
import org.jboss.tools.hibernate.ui.veditor.editors.actions.OpenMappingAction;
import org.jboss.tools.hibernate.ui.veditor.editors.actions.OpenSourceAction;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ModelElement;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmDiagram;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Shape;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.GEFRootEditPart;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.OrmEditPart;
import org.jboss.tools.hibernate.ui.veditor.editors.parts.OrmEditPartFactory;
import org.jboss.tools.hibernate.ui.veditor.editors.popup.PopupMenuProvider;
import org.jboss.tools.hibernate.ui.view.views.ObjectEditorInput;

public class VisualEditor
extends GraphicalEditor {
    private OrmDiagram ormDiagram = null;

    public VisualEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public void doSave(IProgressMonitor monitor) {
        this.ormDiagram.save();
        this.ormDiagram.setDirty(false);
    }

    public void doSaveAs() {
    }

    protected void initializeGraphicalViewer() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new OrmEditPartFactory());
        viewer.setRootEditPart((RootEditPart)new GEFRootEditPart());
        viewer.addDropTargetListener(this.createTransferDropTargetListener());
        viewer.setContents((Object)this.ormDiagram);
        PopupMenuProvider provider = new PopupMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("FlowDiagramContextmenu", (MenuManager)provider, (ISelectionProvider)viewer);
    }

    public GraphicalViewer getEditPartViewer() {
        return this.getGraphicalViewer();
    }

    protected void createActions() {
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)new WorkbenchPartAction((IWorkbenchPart)this){

            protected boolean calculateEnabled() {
                return true;
            }

            public void run() {
                VisualEditor.this.ormDiagram.refresh();
            }
        });
        super.createActions();
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), this.getActionRegistry().getAction((Object)ActionFactory.PRINT.getId()));
        ActionRegistry registry = this.getActionRegistry();
        Object action = new OpenMappingAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new OpenSourceAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new ExportImageAction(this);
        registry.registerAction((IAction)action);
        action = new AutoLayoutAction(this);
        registry.registerAction((IAction)action);
    }

    private TransferDropTargetListener createTransferDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object template) {
                return new SimpleFactory((Class)template);
            }
        };
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void refreshDirty() {
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.ormDiagram.isDirty();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        ObjectEditorInput objectEditorInput = (ObjectEditorInput)input;
        ConsoleConfiguration configuration = objectEditorInput.getConfiguration();
        Object obj = objectEditorInput.getObject();
        if (obj instanceof RootClass) {
            RootClass rootClass = (RootClass)obj;
            this.setPartName("Diagram for " + rootClass.getEntityName());
            this.ormDiagram = new OrmDiagram(configuration, rootClass, objectEditorInput.getJavaProject());
        } else if (obj instanceof RootClass[]) {
            RootClass[] rootClasses = (RootClass[])obj;
            String name = rootClasses.length > 0 ? rootClasses[0].getEntityName() : "";
            int i = 1;
            while (i < rootClasses.length) {
                name = String.valueOf(name) + " & " + rootClasses[i].getEntityName();
                ++i;
            }
            this.setPartName("Diagram for " + name);
            this.ormDiagram = new OrmDiagram(configuration, rootClasses, objectEditorInput.getJavaProject());
        }
    }

    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            DiagramContentOutlinePage outline = new DiagramContentOutlinePage((EditPartViewer)new TreeViewer());
            outline.setGraphicalViewer(this.getGraphicalViewer());
            outline.setSelectionSynchronizer(this.getSelectionSynchronizer());
            outline.setOrmDiagram(this.ormDiagram);
            outline.setEditor(this);
            return outline;
        }
        return super.getAdapter(type);
    }

    public Set getSelectedElements_old() {
        HashSet<Object> ret = new HashSet<Object>();
        List selectedEditParts = this.getGraphicalViewer().getSelectedEditParts();
        for (Object elem : selectedEditParts) {
            if (!(elem instanceof OrmEditPart)) continue;
            Object model = ((OrmEditPart)((Object)elem)).getModel();
            ModelElement shape = (Shape)model;
            while (!(shape instanceof OrmShape)) {
                shape = shape.getParent();
            }
            ret.add(((OrmShape)shape).getOrmElement());
        }
        return ret;
    }

    public Set getSelectedElements() {
        HashSet<Object> ret = new HashSet<Object>();
        List selectedEditParts = this.getGraphicalViewer().getSelectedEditParts();
        for (Object elem : selectedEditParts) {
            if (!(elem instanceof OrmEditPart)) continue;
            Shape shape = (Shape)((OrmEditPart)((Object)elem)).getModel();
            Object ormElement = shape.getOrmElement();
            if (ormElement instanceof Column) {
                shape = (Shape)shape.getParent();
            }
            ret.add(shape.getOrmElement());
        }
        return ret;
    }

    public OrmDiagram getViewerContents() {
        return this.ormDiagram;
    }

    public DefaultEditDomain getDefaultEditDomain() {
        return this.getEditDomain();
    }
}

