/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.actions;

import java.io.FileNotFoundException;
import java.util.Set;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.jboss.tools.hibernate.ui.veditor.VisualEditorPlugin;
import org.jboss.tools.hibernate.ui.veditor.editors.VisualEditor;
import org.jboss.tools.hibernate.ui.view.views.ObjectEditorInput;

public class OpenSourceAction
extends SelectionAction {
    public static String ACTION_ID = "org.jboss.tools.hibernate.ui.veditor.editors.actions.open.source";

    public OpenSourceAction(IWorkbenchPart part) {
        super(part);
        this.setId(ACTION_ID);
        this.setText("Open Source File");
        this.setImageDescriptor(VisualEditorPlugin.getImageDescriptor("icons/java.gif"));
    }

    public void run() {
        ObjectEditorInput objectEditorInput = (ObjectEditorInput)((VisualEditor)this.getWorkbenchPart()).getEditorInput();
        objectEditorInput.getConfiguration();
        IJavaProject proj = objectEditorInput.getJavaProject();
        VisualEditor part = (VisualEditor)this.getWorkbenchPart();
        Set selectedElements = part.getSelectedElements();
        for (Object selection : selectedElements) {
            PersistentClass rootClass = null;
            if (selection instanceof PersistentClass) {
                rootClass = (PersistentClass)selection;
            } else {
                if (!(selection instanceof Property)) continue;
                rootClass = ((Property)selection).getPersistentClass();
            }
            String fullyQualifiedName = rootClass.getClassName();
            try {
                new org.hibernate.eclipse.console.actions.OpenSourceAction().run(selection, proj, fullyQualifiedName);
            }
            catch (PartInitException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Can't open source file.", (Throwable)e);
            }
            catch (JavaModelException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Can't find source file.", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Can't find source file.", (Throwable)e);
            }
        }
    }

    protected boolean calculateEnabled() {
        VisualEditor part = (VisualEditor)this.getWorkbenchPart();
        Set selectedElements = part.getSelectedElements();
        for (Object elem : selectedElements) {
            if (!(elem instanceof PersistentClass) && !(elem instanceof Property)) continue;
            return true;
        }
        return false;
    }
}

