/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jdt.core.IJavaProject;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.tools.hibernate.ui.veditor.VisualEditorPlugin;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ComponentShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Connection;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ExpandeableShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ModelElement;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Shape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.SpecialOrmShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.SpecialRootClass;
import org.jboss.tools.hibernate.ui.view.views.HibernateUtils;

public class OrmDiagram
extends ModelElement {
    public static final String REFRESH = "refresh";
    public static final String DIRTY = "dirty";
    private boolean dirty = false;
    private String[] childrenLocations;
    private HashMap<String, OrmShape> elements = new HashMap();
    private RootClass[] ormElements;
    private Configuration configuration;
    private ConsoleConfiguration consoleConfiguration;
    private IJavaProject javaProject;
    private String[] entityNames;
    public static final String HIBERNATE_MAPPING_LAYOUT_FOLDER_NAME = "hibernateMapping";
    private boolean loadSuccessfull = false;

    public OrmDiagram(ConsoleConfiguration configuration, RootClass ioe, IJavaProject javaProject) {
        this.consoleConfiguration = configuration;
        this.configuration = configuration.getConfiguration();
        this.ormElements = new RootClass[1];
        this.ormElements[0] = ioe;
        this.entityNames = new String[1];
        this.entityNames[0] = ioe.getEntityName();
        this.javaProject = javaProject;
        if (ioe instanceof RootClass) {
            String string = "";
            this.childrenLocations = string.split("#");
        }
        this.getOrCreatePersistentClass((PersistentClass)this.ormElements[0], null);
        this.expandModel(this);
        this.load();
        this.setDirty(false);
    }

    public OrmDiagram(ConsoleConfiguration configuration, RootClass[] ioe, IJavaProject javaProject) {
        this.consoleConfiguration = configuration;
        this.configuration = configuration.getConfiguration();
        this.ormElements = new RootClass[ioe.length];
        System.arraycopy(ioe, 0, this.ormElements, 0, ioe.length);
        this.entityNames = new String[ioe.length];
        int i = 0;
        while (i < this.ormElements.length) {
            this.entityNames[i] = this.ormElements[i].getEntityName();
            ++i;
        }
        this.javaProject = javaProject;
        if (ioe instanceof RootClass[]) {
            String string = "";
            this.childrenLocations = string.split("#");
        }
        i = 0;
        while (i < this.ormElements.length) {
            this.getOrCreatePersistentClass((PersistentClass)this.ormElements[i], null);
            ++i;
        }
        this.expandModel(this);
        this.load();
        this.setDirty(false);
    }

    private IPath getStoreFolderPath() {
        return this.javaProject.getProject().getLocation().append(".settings").append(HIBERNATE_MAPPING_LAYOUT_FOLDER_NAME);
    }

    private IPath getStoreFilePath() {
        return this.getStoreFolderPath().append(this.getStoreFileName());
    }

    private String getStoreFileName() {
        String name = this.ormElements.length > 0 ? this.ormElements[0].getClassName() : "";
        int i = 1;
        while (i < this.ormElements.length) {
            name = String.valueOf(name) + "_" + this.ormElements[i].getClassName();
            ++i;
        }
        return String.valueOf(this.consoleConfiguration.getName()) + "_" + name;
    }

    public HashMap getCloneElements() {
        return (HashMap)this.elements.clone();
    }

    public RootClass getOrmElement(int idx) {
        if (idx < 0 || idx >= this.ormElements.length) {
            return null;
        }
        return this.ormElements[idx];
    }

    public RootClass[] getOrmElements() {
        return this.ormElements;
    }

    public void refresh() {
        boolean bRefresh = false;
        int i = 0;
        while (i < this.ormElements.length) {
            RootClass newOrmElement = (RootClass)this.consoleConfiguration.getConfiguration().getClassMapping(this.entityNames[i]);
            if (!this.ormElements[i].equals(newOrmElement)) {
                this.ormElements[i] = newOrmElement;
                bRefresh = true;
            }
            ++i;
        }
        if (!bRefresh) {
            return;
        }
        this.saveHelper();
        this.getChildren().clear();
        this.elements.clear();
        i = 0;
        while (i < this.ormElements.length) {
            this.getOrCreatePersistentClass((PersistentClass)this.ormElements[i], null);
            ++i;
        }
        this.expandModel(this);
        this.load();
        this.firePropertyChange(REFRESH, null, null);
    }

    private void expandModel(ModelElement element) {
        if (element.getClass().equals(ExpandeableShape.class)) {
            this.processExpand((ExpandeableShape)element);
        } else if (element.getClass().equals(ComponentShape.class)) {
            this.refreshComponentReferences((ComponentShape)element);
        }
        int i = 0;
        while (i < element.getChildren().size()) {
            this.expandModel((ModelElement)element.getChildren().get(i));
            ++i;
        }
    }

    private void saveHelper() {
        this.childrenLocations = new String[this.getChildren().size()];
        int i = 0;
        while (i < this.getChildren().size()) {
            OrmShape shape = (OrmShape)this.getChildren().get(i);
            Object ormElement = shape.getOrmElement();
            if (ormElement instanceof RootClass) {
                this.childrenLocations[i] = String.valueOf(((RootClass)ormElement).getEntityName()) + "@";
            } else if (ormElement instanceof Table) {
                this.childrenLocations[i] = String.valueOf(HibernateUtils.getTableName((Table)((Table)ormElement))) + "@";
            }
            int n = i++;
            this.childrenLocations[n] = String.valueOf(this.childrenLocations[n]) + shape.getLocation().x + ";" + shape.getLocation().y + ";" + shape.isHiden();
        }
    }

    private OrmShape createShape(Object ormElement) {
        String key;
        OrmShape ormShape = null;
        if (ormElement instanceof RootClass) {
            String key2 = HibernateUtils.getPersistentClassName((String)((RootClass)ormElement).getEntityName());
            ormShape = this.elements.get(key2);
            if (ormShape == null) {
                ormShape = new OrmShape(ormElement);
                this.getChildren().add(ormShape);
                this.elements.put(key2, ormShape);
            }
        } else if (ormElement instanceof Table) {
            String key3 = HibernateUtils.getTableName((Table)((Table)ormElement));
            ormShape = this.elements.get(key3);
            if (ormShape == null) {
                ormShape = new OrmShape(ormElement);
                this.getChildren().add(ormShape);
                this.elements.put(key3, ormShape);
            }
        } else if (ormElement instanceof Property) {
            SpecialRootClass specialRootClass = new SpecialRootClass((Property)ormElement);
            String key4 = HibernateUtils.getPersistentClassName((String)specialRootClass.getEntityName());
            ormShape = this.elements.get(key4);
            if (ormShape == null) {
                ormShape = new SpecialOrmShape(specialRootClass);
                this.getChildren().add(ormShape);
                this.elements.put(key4, ormShape);
            }
        } else if (ormElement instanceof Subclass && (ormShape = this.elements.get(key = HibernateUtils.getPersistentClassName((String)((Subclass)ormElement).getEntityName()))) == null) {
            ormShape = new OrmShape(ormElement);
            this.getChildren().add(ormShape);
            this.elements.put(key, ormShape);
        }
        return ormShape;
    }

    public OrmShape getShape(Object ormElement) {
        OrmShape ormShape = null;
        if (ormElement instanceof RootClass) {
            ormShape = this.elements.get(HibernateUtils.getPersistentClassName((String)((RootClass)ormElement).getEntityName()));
        } else if (ormElement instanceof Table) {
            ormShape = this.elements.get(HibernateUtils.getTableName((Table)((Table)ormElement)));
        } else if (ormElement instanceof Property) {
            SpecialRootClass specialRootClass = new SpecialRootClass((Property)ormElement);
            ormShape = this.elements.get(HibernateUtils.getPersistentClassName((String)specialRootClass.getEntityName()));
        } else if (ormElement instanceof Subclass) {
            ormShape = this.elements.get(HibernateUtils.getPersistentClassName((String)((Subclass)ormElement).getEntityName()));
        }
        return ormShape;
    }

    private OrmShape getOrCreatePersistentClass(PersistentClass persistentClass, Table componentClassDatabaseTable) {
        OrmShape classShape = null;
        OrmShape shape = null;
        if (persistentClass != null) {
            OrmShape componentClassShape;
            Component identifier;
            classShape = this.elements.get(HibernateUtils.getPersistentClassName((String)persistentClass.getEntityName()));
            if (classShape == null) {
                classShape = this.createShape(persistentClass);
            }
            if (componentClassDatabaseTable == null && persistentClass.getTable() != null) {
                componentClassDatabaseTable = persistentClass.getTable();
            }
            if (componentClassDatabaseTable != null) {
                shape = this.elements.get(HibernateUtils.getTableName((Table)componentClassDatabaseTable));
                if (shape == null) {
                    shape = this.getOrCreateDatabaseTable(componentClassDatabaseTable);
                }
                this.createConnections(classShape, shape);
                if (!this.isConnectionExist(classShape, shape)) {
                    new Connection(classShape, shape);
                    classShape.firePropertyChange(REFRESH, null, null);
                    shape.firePropertyChange(REFRESH, null, null);
                }
            }
            RootClass rc = (RootClass)persistentClass;
            Iterator iter = rc.getSubclassIterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof Subclass)) continue;
                Subclass subclass = (Subclass)element;
                OrmShape subclassShape = this.elements.get(HibernateUtils.getPersistentClassName((String)subclass.getEntityName()));
                if (subclassShape == null) {
                    subclassShape = this.createShape(subclass);
                }
                if (((Subclass)element).isJoinedSubclass()) {
                    Table jcTable = ((Subclass)element).getTable();
                    OrmShape jcTableShape = this.getOrCreateDatabaseTable(jcTable);
                    this.createConnections(subclassShape, jcTableShape);
                    if (!this.isConnectionExist(subclassShape, jcTableShape)) {
                        new Connection(subclassShape, jcTableShape);
                        subclassShape.firePropertyChange(REFRESH, null, null);
                        jcTableShape.firePropertyChange(REFRESH, null, null);
                    }
                } else {
                    this.createConnections(subclassShape, shape);
                    if (!this.isConnectionExist(subclassShape, shape)) {
                        new Connection(subclassShape, shape);
                        subclassShape.firePropertyChange(REFRESH, null, null);
                        shape.firePropertyChange(REFRESH, null, null);
                    }
                }
                OrmShape ownerTableShape = this.getOrCreateDatabaseTable(((Subclass)element).getRootTable());
                this.createConnections(subclassShape, ownerTableShape);
                Iterator joinIterator = subclass.getJoinIterator();
                while (joinIterator.hasNext()) {
                    Join join = (Join)joinIterator.next();
                    Iterator iterator = join.getPropertyIterator();
                    while (iterator.hasNext()) {
                        Property property = (Property)iterator.next();
                        OrmShape tableShape = this.getOrCreateDatabaseTable(property.getValue().getTable());
                        this.createConnections(subclassShape, tableShape);
                        subclassShape.firePropertyChange(REFRESH, null, null);
                        tableShape.firePropertyChange(REFRESH, null, null);
                    }
                }
            }
            if (persistentClass.getIdentifier() instanceof Component && (identifier = (Component)persistentClass.getIdentifier()).getComponentClassName() != null && !identifier.getComponentClassName().equals(identifier.getOwner().getEntityName()) && (componentClassShape = this.elements.get(identifier.getComponentClassName())) == null && persistentClass instanceof RootClass) {
                componentClassShape = this.getOrCreateComponentClass(((RootClass)persistentClass).getIdentifierProperty());
                Shape idPropertyShape = classShape.getChild(persistentClass.getIdentifierProperty());
                if (idPropertyShape != null && !this.isConnectionExist(idPropertyShape, componentClassShape)) {
                    new Connection(idPropertyShape, componentClassShape);
                    idPropertyShape.firePropertyChange(REFRESH, null, null);
                    componentClassShape.firePropertyChange(REFRESH, null, null);
                }
                OrmShape tableShape = this.getOrCreateDatabaseTable(identifier.getTable());
                if (componentClassShape != null) {
                    this.createConnections(componentClassShape, tableShape);
                    componentClassShape.firePropertyChange(REFRESH, null, null);
                    tableShape.firePropertyChange(REFRESH, null, null);
                }
            }
            Iterator joinIterator = persistentClass.getJoinIterator();
            while (joinIterator.hasNext()) {
                Join join = (Join)joinIterator.next();
                Iterator iterator = join.getPropertyIterator();
                while (iterator.hasNext()) {
                    Property property = (Property)iterator.next();
                    OrmShape tableShape = this.getOrCreateDatabaseTable(property.getValue().getTable());
                    this.createConnections(classShape, tableShape);
                    classShape.firePropertyChange(REFRESH, null, null);
                    tableShape.firePropertyChange(REFRESH, null, null);
                }
            }
        }
        return classShape;
    }

    private OrmShape getOrCreateDatabaseTable(Table databaseTable) {
        String tableName;
        OrmShape tableShape = null;
        if (databaseTable != null && (tableShape = this.elements.get(tableName = HibernateUtils.getTableName((Table)databaseTable))) == null) {
            tableShape = this.createShape(databaseTable);
            Iterator iterator = this.getConfiguration().getClassMappings();
            while (iterator.hasNext()) {
                RootClass cls;
                Table table;
                Object clazz = iterator.next();
                if (!(clazz instanceof RootClass) || !tableName.equals(String.valueOf((table = (cls = (RootClass)clazz).getTable()).getName()) + "." + table.getName()) || this.elements.get(HibernateUtils.getPersistentClassName((String)cls.getEntityName())) != null) continue;
                this.getOrCreatePersistentClass((PersistentClass)cls, null);
            }
        }
        return tableShape;
    }

    private void createConnections(ExpandeableShape persistentClass, ExpandeableShape databaseTable) {
        int i = 0;
        boolean check = persistentClass.getOrmElement() instanceof SpecialRootClass;
        Iterator persistentFields = persistentClass.getChildren().iterator();
        List databaseColumns = databaseTable.getChildren();
        ArrayList<Shape> databaseColumns2 = new ArrayList<Shape>();
        Iterator iterator = null;
        while (persistentFields.hasNext()) {
            Shape shape = (Shape)persistentFields.next();
            Object element = shape.getOrmElement();
            if (!(element instanceof Property) || check && ((SpecialRootClass)((Object)persistentClass.getOrmElement())).getParentProperty() == element) continue;
            Value value = ((Property)element).getValue();
            iterator = value.getColumnIterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                if (!(o instanceof Column)) continue;
                Column databaseColumn = (Column)o;
                int j = 0;
                while (j < databaseColumns.size()) {
                    if (databaseColumn.getName().equals(((Column)((Shape)databaseColumns.get(j)).getOrmElement()).getName())) {
                        Shape databaseShape = (Shape)databaseColumns.remove(j);
                        if (!this.isConnectionExist(shape, databaseShape)) {
                            new Connection(shape, databaseShape);
                            shape.firePropertyChange(REFRESH, null, null);
                            databaseShape.firePropertyChange(REFRESH, null, null);
                        }
                        databaseColumns2.add(i++, databaseShape);
                    }
                    ++j;
                }
            }
        }
        databaseColumns.addAll(databaseColumns2);
    }

    private boolean isConnectionExist(Shape source, Shape target) {
        if (source != null && source.getSourceConnections() != null) {
            int i = 0;
            while (i < source.getSourceConnections().size()) {
                Connection conn = source.getSourceConnections().get(i);
                if (conn.getTarget().equals(target)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String[] getChildrenLocations() {
        return this.childrenLocations;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.firePropertyChange(DIRTY, null, null);
        }
    }

    public void processExpand(ExpandeableShape shape) {
        OrmShape s = null;
        Object element = shape.getOrmElement();
        if (element instanceof Property) {
            Property property = (Property)element;
            if (!property.isComposite()) {
                Type type = ((Property)element).getType();
                if (type.isEntityType()) {
                    EntityType et = (EntityType)type;
                    PersistentClass clazz = this.getConfiguration().getClassMapping(et.getAssociatedEntityName());
                    if (clazz instanceof RootClass) {
                        RootClass rootClass = (RootClass)clazz;
                        s = this.getOrCreatePersistentClass((PersistentClass)rootClass, null);
                        if (!this.isConnectionExist(shape, s)) {
                            new Connection(shape, s);
                            shape.firePropertyChange(REFRESH, null, null);
                            s.firePropertyChange(REFRESH, null, null);
                        }
                    } else if (clazz instanceof Subclass) {
                        s = this.getOrCreatePersistentClass((PersistentClass)((Subclass)clazz).getRootClass(), null);
                    }
                }
            } else {
                s = this.getOrCreatePersistentClass((PersistentClass)new SpecialRootClass(property), null);
                new Connection(shape, s);
                this.createConnections(s, this.getOrCreateDatabaseTable(property.getValue().getTable()));
                shape.firePropertyChange(REFRESH, null, null);
                s.firePropertyChange(REFRESH, null, null);
            }
            if (!shape.getParent().equals(s)) {
                shape.setReference(s);
            }
            this.firePropertyChange(REFRESH, null, null);
        }
    }

    public void update() {
        this.firePropertyChange(REFRESH, null, null);
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected void refreshComponentReferences(ComponentShape componentShape) {
        OrmShape childShape = null;
        Property property = (Property)componentShape.getOrmElement();
        if (property.getValue() instanceof Collection) {
            Collection collection = (Collection)property.getValue();
            Value component = collection.getElement();
            if (component instanceof Component) {
                childShape = this.elements.get(((Component)component).getComponentClassName());
                if (childShape == null) {
                    childShape = this.getOrCreateComponentClass(property);
                }
                SimpleValue value = (SimpleValue)((Shape)componentShape.getChildren().get(0)).getOrmElement();
                OrmShape tableShape = this.getOrCreateDatabaseTable(value.getTable());
                Iterator iterator = value.getColumnIterator();
                while (iterator.hasNext()) {
                    Column column = (Column)iterator.next();
                    Shape colShape = tableShape.getChild(column);
                    if (this.isConnectionExist((Shape)componentShape.getChildren().get(0), colShape)) continue;
                    new Connection((Shape)componentShape.getChildren().get(0), colShape);
                    ((Shape)componentShape.getChildren().get(0)).firePropertyChange(REFRESH, null, null);
                    childShape.firePropertyChange(REFRESH, null, null);
                }
                if (!this.isConnectionExist((Shape)componentShape.getChildren().get(1), childShape)) {
                    new Connection((Shape)componentShape.getChildren().get(1), childShape);
                    ((Shape)componentShape.getChildren().get(1)).firePropertyChange(REFRESH, null, null);
                    childShape.firePropertyChange(REFRESH, null, null);
                }
            } else if (collection.isOneToMany()) {
                childShape = this.getOrCreateAssociationClass(property);
                if (childShape == null) {
                    return;
                }
                if (!this.isConnectionExist((Shape)componentShape.getChildren().get(1), childShape)) {
                    new Connection((Shape)componentShape.getChildren().get(1), childShape);
                    ((Shape)componentShape.getChildren().get(1)).firePropertyChange(REFRESH, null, null);
                    childShape.firePropertyChange(REFRESH, null, null);
                }
                OrmShape keyTableShape = this.getOrCreateDatabaseTable(collection.getKey().getTable());
                Iterator iter = collection.getKey().getColumnIterator();
                while (iter.hasNext()) {
                    Column col = (Column)iter.next();
                    Shape keyColumnShape = keyTableShape.getChild(col);
                    if (keyColumnShape == null || this.isConnectionExist((Shape)componentShape.getChildren().get(0), keyColumnShape)) continue;
                    new Connection((Shape)componentShape.getChildren().get(0), keyColumnShape);
                    ((Shape)componentShape.getChildren().get(0)).firePropertyChange(REFRESH, null, null);
                    keyColumnShape.firePropertyChange(REFRESH, null, null);
                }
            } else {
                childShape = this.getOrCreateDatabaseTable(collection.getCollectionTable());
                Iterator columnIterator = ((DependantValue)((Shape)componentShape.getChildren().get(0)).getOrmElement()).getColumnIterator();
                while (columnIterator.hasNext()) {
                    Shape keyShape = childShape.getChild((Column)columnIterator.next());
                    if (this.isConnectionExist((Shape)componentShape.getChildren().get(0), keyShape)) continue;
                    new Connection((Shape)componentShape.getChildren().get(0), keyShape);
                    ((Shape)componentShape.getChildren().get(0)).firePropertyChange(REFRESH, null, null);
                    keyShape.firePropertyChange(REFRESH, null, null);
                }
                Iterator iter = ((SimpleValue)((Shape)componentShape.getChildren().get(1)).getOrmElement()).getColumnIterator();
                while (iter.hasNext()) {
                    Object element = iter.next();
                    if (!(element instanceof Column)) continue;
                    Column col = (Column)element;
                    Shape elementShape = childShape.getChild(col);
                    if (this.isConnectionExist((Shape)componentShape.getChildren().get(1), elementShape)) continue;
                    new Connection((Shape)componentShape.getChildren().get(1), elementShape);
                    ((Shape)componentShape.getChildren().get(1)).firePropertyChange(REFRESH, null, null);
                    elementShape.firePropertyChange(REFRESH, null, null);
                }
            }
            if (!componentShape.getParent().equals(childShape)) {
                componentShape.setReference(childShape);
            }
            this.setDirty(true);
            this.firePropertyChange(REFRESH, null, null);
        }
    }

    public OrmShape getOrCreateComponentClass(Property property) {
        OrmShape classShape = null;
        if (property != null) {
            if (property.getValue() instanceof Collection) {
                Component component = (Component)((Collection)property.getValue()).getElement();
                if (component != null) {
                    OrmShape parentClassShape;
                    Shape parentShape;
                    classShape = this.createShape(property);
                    OrmShape tableShape = this.elements.get(HibernateUtils.getTableName((Table)component.getTable()));
                    if (tableShape == null) {
                        tableShape = this.getOrCreateDatabaseTable(component.getTable());
                    }
                    this.createConnections(classShape, tableShape);
                    if (!this.isConnectionExist(classShape, tableShape)) {
                        new Connection(classShape, tableShape);
                        classShape.firePropertyChange(REFRESH, null, null);
                        tableShape.firePropertyChange(REFRESH, null, null);
                    }
                    if ((parentShape = ((SpecialOrmShape)classShape).getParentShape()) != null && !this.isConnectionExist(parentShape, parentClassShape = this.elements.get(HibernateUtils.getPersistentClassName((String)((Property)parentShape.getOrmElement()).getPersistentClass().getEntityName())))) {
                        new Connection(parentShape, parentClassShape);
                        parentShape.firePropertyChange(REFRESH, null, null);
                        parentClassShape.firePropertyChange(REFRESH, null, null);
                    }
                }
            } else if (property.getValue() instanceof Component && (classShape = this.elements.get(((Component)property.getValue()).getComponentClassName())) == null) {
                classShape = this.createShape(property);
            }
        }
        return classShape;
    }

    private OrmShape getOrCreateAssociationClass(Property property) {
        OrmShape classShape = null;
        OneToMany component = (OneToMany)((Collection)property.getValue()).getElement();
        if (component != null && component.getAssociatedClass() instanceof RootClass) {
            OrmShape tableShape;
            classShape = this.getOrCreatePersistentClass(component.getAssociatedClass(), null);
            if (classShape == null) {
                classShape = this.createShape(component.getAssociatedClass());
            }
            if ((tableShape = this.elements.get(HibernateUtils.getTableName((Table)component.getAssociatedClass().getTable()))) == null) {
                tableShape = this.getOrCreateDatabaseTable(component.getAssociatedClass().getTable());
            }
            this.createConnections(classShape, tableShape);
            if (!this.isConnectionExist(classShape, tableShape)) {
                new Connection(classShape, tableShape);
                classShape.firePropertyChange(REFRESH, null, null);
                tableShape.firePropertyChange(REFRESH, null, null);
            }
        }
        return classShape;
    }

    public String getKey(Shape shape) {
        Object element = shape.getOrmElement();
        String key = null;
        if (element instanceof RootClass) {
            key = HibernateUtils.getPersistentClassName((String)((RootClass)element).getEntityName());
        } else if (element instanceof Table) {
            key = HibernateUtils.getTableName((Table)((Table)element));
        } else if (element instanceof Property) {
            Property property = (Property)element;
            key = String.valueOf(property.getPersistentClass().getEntityName()) + "." + property.getName();
        } else if (element instanceof Subclass) {
            key = HibernateUtils.getPersistentClassName((String)((Subclass)element).getEntityName());
        }
        return key;
    }

    public void propertiesInit(Properties properties, ModelElement shape) {
        boolean state;
        if (shape instanceof OrmShape) {
            state = this.getState(properties, (Shape)shape);
            if (state) {
                ((OrmShape)shape).refreshHiden();
            }
            ((OrmShape)shape).setLocation(this.getPosition(properties, (OrmShape)shape));
        } else if (shape instanceof ExpandeableShape && !(state = this.getState(properties, (Shape)shape))) {
            ((ExpandeableShape)shape).refHide = false;
        }
        int i = 0;
        while (i < shape.getChildren().size()) {
            this.propertiesInit(properties, (ModelElement)shape.getChildren().get(i));
            ++i;
        }
    }

    private void storeProperties(Properties properties, ModelElement shape) {
        boolean state;
        if (shape instanceof OrmShape) {
            state = ((OrmShape)shape).hiden;
            this.setState(properties, (Shape)shape, state);
            this.setPosition(properties, (OrmShape)shape);
        } else if (shape instanceof ExpandeableShape) {
            state = ((ExpandeableShape)shape).refHide;
            this.setState(properties, (Shape)shape, state);
        }
        int i = 0;
        while (i < shape.getChildren().size()) {
            this.storeProperties(properties, (Shape)shape.getChildren().get(i));
            ++i;
        }
    }

    public void save() {
        Properties properties = new Properties();
        this.storeProperties(properties, this);
        try {
            File file;
            File folder = new File(this.getStoreFolderPath().toOSString());
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (!(file = new File(this.getStoreFilePath().toOSString())).exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            properties.store(fos, "");
        }
        catch (IOException e) {
            VisualEditorPlugin.getDefault().logError("Can't save layout of mapping.", e);
        }
    }

    public IFile createLayoutFile(InputStream source) {
        IFile file = null;
        IPath path = this.javaProject.getProject().getLocation().append(".settings").append(HIBERNATE_MAPPING_LAYOUT_FOLDER_NAME);
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
                file = folder.getFile(this.getStoreFileName());
                if (!file.exists()) {
                    file.create(source, true, null);
                }
            }
            catch (CoreException e) {
                VisualEditorPlugin.getDefault().logError(e);
            }
        }
        return file;
    }

    public void load() {
        Properties properties = new Properties();
        try {
            File file = new File(this.getStoreFilePath().toOSString());
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                properties.load(fis);
                this.propertiesInit(properties, this);
                this.loadSuccessfull = true;
            }
        }
        catch (IOException ex) {
            VisualEditorPlugin.getDefault().logError("Can't load layout of mapping.", ex);
        }
    }

    public boolean isLoadSuccessfull() {
        return this.loadSuccessfull;
    }

    private void setState(Properties properties, String key, boolean value) {
        if (properties.containsKey(key)) {
            properties.remove(key);
            properties.put(key, new Boolean(value).toString());
        } else {
            properties.put(key, new Boolean(value).toString());
        }
    }

    public void setState(Properties properties, Shape shape, boolean value) {
        this.setState(properties, String.valueOf(this.getKey(shape)) + ".state", value);
    }

    private boolean getState(Properties properties, String key) {
        String str = properties.getProperty(key, "true");
        return new Boolean(str);
    }

    private Point getPoint(Properties properties, String key) {
        Point point = new Point(0, 0);
        String str = properties.getProperty(String.valueOf(key) + ".x", "0");
        point.x = Integer.parseInt(str);
        String str2 = properties.getProperty(String.valueOf(key) + ".y", "0");
        point.y = Integer.parseInt(str2);
        return point;
    }

    private void setPoint(Properties properties, String key, Point point) {
        String key1 = String.valueOf(key) + ".x";
        if (!properties.containsKey(key1)) {
            properties.remove(key1);
            properties.put(key1, "" + point.x);
        } else {
            properties.put(key1, "" + point.x);
        }
        String key2 = String.valueOf(key) + ".y";
        if (!properties.containsKey(key2)) {
            properties.remove(key2);
            properties.put(key2, "" + point.y);
        } else {
            properties.put(key2, "" + point.y);
        }
    }

    public void setPosition(Properties properties, OrmShape shape) {
        Point point = shape.getLocation();
        this.setPoint(properties, this.getKey(shape), point);
    }

    public Point getPosition(Properties properties, OrmShape shape) {
        return this.getPoint(properties, this.getKey(shape));
    }

    public boolean getState(Properties properties, Shape shape) {
        return this.getState(properties, String.valueOf(this.getKey(shape)) + ".state");
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public ConsoleConfiguration getConsoleConfiguration() {
        return this.consoleConfiguration;
    }
}

