/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Connection;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ModelElement;
import org.jboss.tools.hibernate.ui.view.views.HibernateUtils;
import org.jboss.tools.hibernate.ui.view.views.OrmModelNameVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shape
extends ModelElement {
    private int indent = 0;
    private List<Connection> sourceConnections = new ArrayList<Connection>();
    private List<Connection> targetConnections = new ArrayList<Connection>();
    public static final String HIDE_SELECTION = "hide selection";
    public static final String SHOW_SELECTION = "show selection";
    public static final String SET_FOCUS = "set focus";
    private Object ormElement;
    static OrmModelNameVisitor ormModelNameVisitor = new OrmModelNameVisitor();
    private static IPropertyDescriptor[] descriptors_property = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"name", "name"), new TextPropertyDescriptor((Object)"type", "type"), new TextPropertyDescriptor((Object)"value", "value"), new TextPropertyDescriptor((Object)"persistanceClass", "persistanceClass"), new TextPropertyDescriptor((Object)"selectable", "selectable"), new TextPropertyDescriptor((Object)"insertable", "insertable"), new TextPropertyDescriptor((Object)"updateable", "updateable"), new TextPropertyDescriptor((Object)"cascade", "cascade"), new TextPropertyDescriptor((Object)"lazy", "lazy"), new TextPropertyDescriptor((Object)"optional", "optional"), new TextPropertyDescriptor((Object)"naturalIdentifier", "naturalIdentifier"), new TextPropertyDescriptor((Object)"nodeName", "nodeName"), new TextPropertyDescriptor((Object)"optimisticLocked", "optimisticLocked")};
    private static IPropertyDescriptor[] descriptors_column = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"name", "name"), new TextPropertyDescriptor((Object)"type", "type"), new TextPropertyDescriptor((Object)"value", "value"), new TextPropertyDescriptor((Object)"nullable", "nullable"), new TextPropertyDescriptor((Object)"unique", "unique")};
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_TYPE = "type";
    private static final String PROPERTY_CLASS = "persistanceClass";
    private static final String PROPERTY_VALUE = "value";
    private static final String PROPERTY_SELECT = "selectable";
    private static final String PROPERTY_INSERT = "insertable";
    private static final String PROPERTY_UPDATE = "updateable";
    private static final String PROPERTY_CASCADE = "cascade";
    private static final String PROPERTY_LAZY = "lazy";
    private static final String PROPERTY_OPTIONAL = "optional";
    private static final String PROPERTY_NATURAL_IDENTIFIER = "naturalIdentifier";
    private static final String PROPERTY_NODE_NAME = "nodeName";
    private static final String PROPERTY_OPTIMISTIC_LOCKED = "optimisticLocked";
    private static final String PROPERTY_NULLABLE = "nullable";
    private static final String PROPERTY_UNIQUE = "unique";

    protected Shape(Object ioe) {
        this.ormElement = ioe;
    }

    public void addConnection(Connection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.add(conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.add(conn);
        }
    }

    public List<Connection> getSourceConnections() {
        return this.sourceConnections;
    }

    public List<Connection> getTargetConnections() {
        return this.targetConnections;
    }

    public Object getOrmElement() {
        return this.ormElement;
    }

    public void hideSelection() {
        this.firePropertyChange(HIDE_SELECTION, null, null);
    }

    public void showSelection() {
        this.firePropertyChange(SHOW_SELECTION, null, null);
    }

    public void setFocus() {
        this.firePropertyChange(SET_FOCUS, null, null);
    }

    public int getIndent() {
        return this.indent;
    }

    protected void setIndent(int indent) {
        this.indent = indent;
    }

    protected void setHidden(boolean hiden) {
        int i = 0;
        while (i < this.sourceConnections.size()) {
            this.sourceConnections.get(i).setHidden(hiden);
            ++i;
        }
        i = 0;
        while (i < this.targetConnections.size()) {
            this.targetConnections.get(i).setHidden(hiden);
            ++i;
        }
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.getOrmElement() instanceof Property) {
            return descriptors_property;
        }
        if (this.getOrmElement() instanceof Column) {
            return descriptors_column;
        }
        return super.getPropertyDescriptors();
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (PROPERTY_NAME.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return ((Property)this.getOrmElement()).getName();
            }
            if (this.getOrmElement() instanceof Column) {
                return ((Column)this.getOrmElement()).getName();
            }
        } else if (PROPERTY_TYPE.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                Value value = ((Property)this.getOrmElement()).getValue();
                if (value instanceof Component) {
                    return ((Property)this.getOrmElement()).getValue().toString();
                }
                return ((Property)this.getOrmElement()).getType().getReturnedClass().getName();
            }
            if (this.getOrmElement() instanceof Column) {
                String type = ormModelNameVisitor.getColumnSqlType((Column)this.getOrmElement(), (Object)this.getOrmDiagram().getConsoleConfiguration());
                Column column = (Column)this.getOrmElement();
                StringBuffer name = new StringBuffer();
                if (type != null) {
                    name.append(type != null ? type.toUpperCase() : "");
                    name.append(HibernateUtils.getTable((Column)column) != null && HibernateUtils.isPrimaryKey((Column)column) ? " PK" : "");
                    name.append(HibernateUtils.getTable((Column)column) != null && HibernateUtils.isForeignKey((Column)column) ? " FK" : "");
                }
                return name.toString();
            }
        } else if (PROPERTY_VALUE.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return ((Property)this.getOrmElement()).getValue().toString();
            }
            if (this.getOrmElement() instanceof Column) {
                return ((Column)this.getOrmElement()).getValue().toString();
            }
        } else if (PROPERTY_CLASS.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                if (((Property)this.getOrmElement()).getPersistentClass() != null) {
                    return ((Property)this.getOrmElement()).getPersistentClass().getClassName();
                }
                return null;
            }
        } else if (PROPERTY_SELECT.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return Boolean.valueOf(((Property)this.getOrmElement()).isSelectable()).toString();
            }
        } else if (PROPERTY_INSERT.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return Boolean.valueOf(((Property)this.getOrmElement()).isInsertable()).toString();
            }
        } else if (PROPERTY_UPDATE.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return Boolean.valueOf(((Property)this.getOrmElement()).isUpdateable()).toString();
            }
        } else if (PROPERTY_CASCADE.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return ((Property)this.getOrmElement()).getCascade();
            }
        } else if (PROPERTY_LAZY.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return Boolean.valueOf(((Property)this.getOrmElement()).isLazy()).toString();
            }
        } else if (PROPERTY_OPTIONAL.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return Boolean.valueOf(((Property)this.getOrmElement()).isOptional()).toString();
            }
        } else if (PROPERTY_NATURAL_IDENTIFIER.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return Boolean.valueOf(((Property)this.getOrmElement()).isNaturalIdentifier()).toString();
            }
        } else if (PROPERTY_NODE_NAME.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return ((Property)this.getOrmElement()).getNodeName();
            }
        } else if (PROPERTY_OPTIMISTIC_LOCKED.equals(propertyId)) {
            if (this.getOrmElement() instanceof Property) {
                return Boolean.valueOf(((Property)this.getOrmElement()).isOptimisticLocked()).toString();
            }
        } else if (PROPERTY_NULLABLE.equals(propertyId)) {
            if (this.getOrmElement() instanceof Column) {
                return Boolean.valueOf(((Column)this.getOrmElement()).isNullable()).toString();
            }
        } else if (PROPERTY_UNIQUE.equals(propertyId) && this.getOrmElement() instanceof Column) {
            return Boolean.valueOf(((Column)this.getOrmElement()).isUnique()).toString();
        }
        return super.getPropertyValue(propertyId);
    }
}

