/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.veditor.editors.model;

import java.util.Iterator;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.type.Type;
import org.jboss.tools.hibernate.ui.veditor.VisualEditorPlugin;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ComponentShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.ExpandeableShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.Shape;
import org.jboss.tools.hibernate.ui.veditor.editors.model.SpecialRootClass;

public class SpecialOrmShape
extends OrmShape {
    private Shape parentShape;

    public SpecialOrmShape(SpecialRootClass ioe) {
        super((Object)ioe);
    }

    protected void generate() {
        Shape bodyOrmShape;
        SpecialRootClass src;
        RootClass rootClass = (RootClass)this.getOrmElement();
        Property identifierProperty = rootClass.getIdentifierProperty();
        if (identifierProperty != null) {
            this.getChildren().add(new Shape(identifierProperty));
        }
        if ((src = (SpecialRootClass)((Object)this.getOrmElement())).getParentProperty() != null) {
            bodyOrmShape = new Shape(src.getParentProperty());
            this.getChildren().add(bodyOrmShape);
            this.parentShape = bodyOrmShape;
        }
        Iterator iterator = rootClass.getPropertyIterator();
        while (iterator.hasNext()) {
            Property field = (Property)iterator.next();
            try {
                Type type = null;
                if (this.getOrmDiagram() != null) {
                    ConsoleConfiguration cfg = this.getOrmDiagram().getConsoleConfiguration();
                    final Property fField = field;
                    type = (Type)cfg.execute(new ExecutionContext.Command(){

                        public Object execute() {
                            return fField.getValue().getType();
                        }
                    });
                } else {
                    try {
                        type = field.getValue().getType();
                    }
                    catch (Exception e) {
                        VisualEditorPlugin.getDefault().logError(e);
                    }
                }
                bodyOrmShape = type != null && type.isEntityType() ? new ExpandeableShape(field) : (type != null && type.isCollectionType() ? new ComponentShape(field) : new Shape(field));
                this.getChildren().add(bodyOrmShape);
            }
            catch (Exception e) {
                VisualEditorPlugin.getDefault().logError(e);
            }
        }
    }

    protected Shape getParentShape() {
        return this.parentShape;
    }
}

