/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.QueryPage;

public abstract class AbstractQueryPage
implements QueryPage {
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private int id;
    private Session session;
    private final ConsoleConfiguration cfg;
    protected List list;
    protected long queryTime = -1L;
    List pathNames;
    protected boolean sticky = true;
    private List exceptions = new ArrayList();

    public void setId(int i) {
        this.id = i;
    }

    public int getResultSize() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    public AbstractQueryPage(ConsoleConfiguration cfg) {
        this.cfg = cfg;
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void release() {
        if (this.getSession().isOpen()) {
            try {
                this.getSession().close();
            }
            catch (HibernateException e) {
                this.exceptions.add(e);
            }
        }
    }

    public int getID() {
        return this.id;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session s) {
        this.session = s;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void addException(Throwable e) {
        this.exceptions.add(e);
        this.release();
        this.pcs.firePropertyChange("exceptions", null, this.exceptions);
    }

    public ConsoleConfiguration getConsoleConfiguration() {
        return this.cfg;
    }

    public long getQueryTime() {
        return this.queryTime;
    }
}

