/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.node;

import java.util.Arrays;
import java.util.Comparator;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.KnownConfigurationsListener;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.ConfigurationNode;

public class ConfigurationListNode
extends BaseNode {
    private boolean childrenCreated;
    private final KnownConfigurations kc;

    public ConfigurationListNode(KnownConfigurations kc) {
        super(null, null);
        this.kc = kc;
        kc.addConsoleConfigurationListener(new KnownConfigurationsListener(){

            public void configurationAdded(ConsoleConfiguration root) {
                this.markChildrenForReload();
            }

            private void markChildrenForReload() {
                ConfigurationListNode.this.children.clear();
                ConfigurationListNode.this.childrenCreated = false;
            }

            public void configurationRemoved(ConsoleConfiguration root, boolean forUpdate) {
                this.markChildrenForReload();
            }

            public void sessionFactoryClosing(ConsoleConfiguration configuration, SessionFactory closingFactory) {
            }

            public void sessionFactoryBuilt(ConsoleConfiguration ccfg, SessionFactory builtFactory) {
            }
        });
    }

    protected void checkChildren() {
        if (!this.childrenCreated) {
            ConsoleConfiguration[] configurations = this.kc.getConfigurations();
            Arrays.sort(configurations, new Comparator(){

                public boolean equals(Object obj) {
                    return this == obj;
                }

                public int compare(Object o1, Object o2) {
                    return ((ConsoleConfiguration)o1).getName().compareTo(((ConsoleConfiguration)o2).getName());
                }
            });
            int i = 0;
            while (i < configurations.length) {
                this.children.add(new ConfigurationNode(this, configurations[i]));
                ++i;
            }
            this.childrenCreated = true;
        }
    }

    public String getHQL() {
        return null;
    }
}

