/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.util.StringHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractConsoleConfigurationPreferences
implements ConsoleConfigurationPreferences {
    static final String PROJECT_ATTRIB = "project";
    static final String USE_PROJECT_CLASSPATH_ATTRIB = "use-project-classpath";
    private String projectName;
    private String name = "<unknown>";
    protected String entityResolverName = null;
    private boolean useProjectClasspath;
    private ConsoleConfigurationPreferences.ConfigurationMode configurationMode;
    private String persistenceUnitName;
    private String namingStrategy;

    public AbstractConsoleConfigurationPreferences(String name, ConsoleConfigurationPreferences.ConfigurationMode configurationMode, String projectName, boolean useProjectclassPath, String entityResolver, String persistenceUnitName, String namingStrategy) {
        this.setName(name);
        this.persistenceUnitName = persistenceUnitName;
        this.namingStrategy = namingStrategy;
        this.configurationMode = configurationMode;
        this.entityResolverName = entityResolver;
        this.projectName = projectName;
        this.useProjectClasspath = useProjectclassPath;
    }

    protected AbstractConsoleConfigurationPreferences() {
    }

    public ConsoleConfigurationPreferences.ConfigurationMode getConfigurationMode() {
        return this.configurationMode;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public String getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final Properties getProperties() {
        File propFile = this.getPropertyFile();
        if (propFile == null) {
            return null;
        }
        try {
            Properties p = new Properties();
            p.load(new FileInputStream(propFile));
            return p;
        }
        catch (IOException io) {
            throw new HibernateConsoleRuntimeException("Could not load property file " + propFile, io);
        }
    }

    protected static void writeStateTo(Node node, String name, String entityResolver, ConsoleConfigurationPreferences.ConfigurationMode configurationMode, String projectName, boolean useProjectClasspath, Object cfgFile, Object propertyFilename, Object[] mappings, Object[] customClasspath) {
        Object path;
        int i;
        Element cc;
        Document doc = node.getOwnerDocument();
        Element n = AbstractConsoleConfigurationPreferences.createElementWithAttribute(doc, "configuration", "name", name);
        n.setAttribute("configuration-factory", configurationMode.toString());
        if (StringHelper.isNotEmpty((String)entityResolver)) {
            n.setAttribute("entityresolver", entityResolver);
        }
        if (useProjectClasspath) {
            n.setAttribute(USE_PROJECT_CLASSPATH_ATTRIB, "true");
        }
        if (StringHelper.isNotEmpty((String)projectName)) {
            n.setAttribute(PROJECT_ATTRIB, projectName);
        }
        node.appendChild(n);
        if (cfgFile != null) {
            n.appendChild(AbstractConsoleConfigurationPreferences.createElementWithAttribute(doc, "hibernate-config-xml", "location", cfgFile.toString()));
        }
        if (propertyFilename != null) {
            n.appendChild(AbstractConsoleConfigurationPreferences.createElementWithAttribute(doc, "hibernate-properties", "location", propertyFilename.toString()));
        }
        if (mappings.length > 0) {
            cc = AbstractConsoleConfigurationPreferences.createElementWithAttribute(doc, "mappings", null, null);
            n.appendChild(cc);
            i = 0;
            while (i < mappings.length) {
                path = mappings[i];
                cc.appendChild(AbstractConsoleConfigurationPreferences.createElementWithAttribute(doc, "mapping", "location", path.toString()));
                ++i;
            }
        }
        if (customClasspath.length > 0) {
            cc = AbstractConsoleConfigurationPreferences.createElementWithAttribute(doc, "classpath", null, null);
            n.appendChild(cc);
            i = 0;
            while (i < customClasspath.length) {
                path = customClasspath[i];
                cc.appendChild(AbstractConsoleConfigurationPreferences.createElementWithAttribute(doc, "path", "location", path.toString()));
                ++i;
            }
        }
    }

    public boolean useProjectClasspath() {
        return this.useProjectClasspath;
    }

    protected void setUseProjectClasspath(boolean useProjectClasspath) {
        this.useProjectClasspath = useProjectClasspath;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void readStateFrom(Element node) {
        NodeList elements;
        String entityResolver = null;
        String cfgName = null;
        String cfgFile = null;
        String propFile = null;
        String[] mappings = new String[]{};
        String[] classpath = new String[]{};
        cfgName = node.getAttribute("name");
        String attribute = node.getAttribute("annotations");
        if (StringHelper.isNotEmpty((String)attribute)) {
            boolean oldAnnotationFlag;
            boolean bl = oldAnnotationFlag = attribute != null && attribute.equalsIgnoreCase("true");
            this.configurationMode = oldAnnotationFlag ? ConsoleConfigurationPreferences.ConfigurationMode.ANNOTATIONS : ConsoleConfigurationPreferences.ConfigurationMode.CORE;
        } else {
            attribute = node.getAttribute("configuration-factory");
            this.configurationMode = ConsoleConfigurationPreferences.ConfigurationMode.parse(attribute);
        }
        attribute = node.getAttribute(PROJECT_ATTRIB);
        this.setProjectName(attribute);
        attribute = node.getAttribute(USE_PROJECT_CLASSPATH_ATTRIB);
        this.setUseProjectClasspath(attribute != null && attribute.equalsIgnoreCase("true"));
        attribute = node.getAttribute("entityresolver");
        if (attribute != null && attribute.trim().length() > 0) {
            entityResolver = attribute;
        }
        if ((elements = node.getElementsByTagName("hibernate-config-xml")).getLength() == 1) {
            cfgFile = ((Element)elements.item(0)).getAttribute("location");
        }
        if ((elements = node.getElementsByTagName("hibernate-properties")).getLength() == 1) {
            propFile = ((Element)elements.item(0)).getAttribute("location");
        }
        mappings = this.parseListOfLocations(node, "mappings", "mapping");
        classpath = this.parseListOfLocations(node, "classpath", "path");
        this.setName(cfgName);
        this.setEntityResolverName(entityResolver);
        this.setConfigFile(cfgFile);
        this.setPropertyFile(propFile);
        this.setMappings(mappings);
        this.setCustomClassPath(classpath);
    }

    private void setEntityResolverName(String entityResolver) {
        this.entityResolverName = entityResolver;
    }

    private String[] parseListOfLocations(Element node, String parenttag, String elementag) {
        String[] result = new String[]{};
        NodeList elements = node.getElementsByTagName(parenttag);
        if (elements.getLength() == 1) {
            NodeList maps = ((Element)elements.item(0)).getElementsByTagName(elementag);
            result = new String[maps.getLength()];
            int j = 0;
            while (j < maps.getLength()) {
                Element child = (Element)maps.item(j);
                result[j] = child.getAttribute("location");
                ++j;
            }
        }
        return result;
    }

    public String getEntityResolverName() {
        return this.entityResolverName;
    }

    protected abstract void setConfigFile(String var1);

    protected abstract void setPropertyFile(String var1);

    protected abstract void setMappings(String[] var1);

    protected abstract void setCustomClassPath(String[] var1);

    protected static Element createElementWithAttribute(Document doc, String tagName, String attribName, String attributValue) {
        Element n = doc.createElement(tagName);
        if (attribName != null) {
            n.setAttribute(attribName, attributValue);
        }
        return n;
    }
}

