/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IShowEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.QueryInputModel;
import org.hibernate.eclipse.console.ComboContribution;
import org.hibernate.eclipse.console.ConfigurationCombo;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.QueryEditor;
import org.hibernate.eclipse.console.QueryEditorInput;
import org.hibernate.eclipse.console.actions.ExecuteQueryAction;

public abstract class AbstractQueryEditor
extends TextEditor
implements QueryEditor,
IShowEditorInput {
    private ToolBarManager tbm;
    private ExecuteQueryAction execAction = null;
    private final QueryInputModel queryInputModel = new QueryInputModel();
    private String defPartName;
    private Image defTitleImage;
    private Image connectedTitleImage;
    private String consoleConfigurationName;

    public final boolean askUserForConfiguration(String name) {
        return MessageDialog.openQuestion((Shell)HibernateConsolePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Session factory", (String)("Do you want to open the session factory for " + name + " ?"));
    }

    public final ConsoleConfiguration getConsoleConfiguration() {
        return KnownConfigurations.getInstance().find(this.getConsoleConfigurationName());
    }

    public final String getConsoleConfigurationName() {
        if (this.getEditorInput() instanceof QueryEditorInput) {
            QueryEditorInput hei = (QueryEditorInput)this.getEditorInput();
            return hei.getConsoleConfigurationName();
        }
        return this.consoleConfigurationName;
    }

    public final void setConsoleConfigurationName(String name) {
        if (this.getEditorInput() instanceof QueryEditorInput) {
            QueryEditorInput hei = (QueryEditorInput)this.getEditorInput();
            hei.setConsoleConfigurationName(name);
            hei.setQuery(this.getQueryString());
            hei.resetName();
        }
        this.consoleConfigurationName = name;
        this.showEditorInput(this.getEditorInput());
    }

    protected void updateExecButton() {
        this.execAction.setEnabled(this.getQueryString().trim().length() > 0 && this.getConsoleConfigurationName().length() != 0);
    }

    public void showEditorInput(IEditorInput editorInput) {
        try {
            this.doSetInput(editorInput);
            this.updateExecButton();
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Could not show query editor input", e);
        }
    }

    public final void doSave(IProgressMonitor progressMonitor) {
        if (this.getEditorInput() instanceof QueryEditorInput) {
            QueryEditorInput hei = (QueryEditorInput)this.getEditorInput();
            hei.setQuery(this.getQueryString());
        }
        this.performSave(false, progressMonitor);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
    }

    public final String getQueryString() {
        IEditorInput editorInput = this.getEditorInput();
        IDocumentProvider docProvider = this.getDocumentProvider();
        IDocument doc = docProvider.getDocument((Object)editorInput);
        return doc.get();
    }

    public final void dispose() {
        super.dispose();
        if (this.tbm != null) {
            this.tbm.dispose();
        }
    }

    protected final void createToolbar(Composite parent) {
        ToolBar bar = new ToolBar(parent, 256);
        bar.setLayoutData((Object)new GridData(768));
        this.tbm = new ToolBarManager(bar);
        this.execAction = new ExecuteQueryAction(this);
        ActionContributionItem item = new ActionContributionItem((IAction)this.execAction);
        this.tbm.add((IContributionItem)item);
        ComboContribution cc = new ConfigurationCombo("hql-target", this);
        this.tbm.add((IContributionItem)cc);
        this.tbm.add((IContributionItem)new Separator());
        cc = new ComboContribution("maxResults"){
            SelectionAdapter selectionAdapter;
            {
                this.selectionAdapter = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Integer maxResults = null;
                        try {
                            maxResults = new Integer(this.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            maxResults = null;
                        }
                        AbstractQueryEditor.this.queryInputModel.setMaxResults(maxResults);
                    }
                };
            }

            protected Control createControl(Composite parent) {
                Control control = super.createControl(parent);
                this.comboControl.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        Integer maxResults = null;
                        try {
                            maxResults = new Integer(this.getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            maxResults = null;
                        }
                        AbstractQueryEditor.this.queryInputModel.setMaxResults(maxResults);
                    }
                });
                return control;
            }

            protected int getComboWidth() {
                return 75;
            }

            protected String getLabelText() {
                return "Max results:";
            }

            protected boolean isReadOnly() {
                return false;
            }

            protected SelectionListener getSelectionAdapter() {
                return this.selectionAdapter;
            }

            void populateComboBox() {
                this.comboControl.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        String[] items = new String[]{"", "10", "20", "30", "50"};
                        comboControl.setItems(items);
                    }
                });
            }
        };
        this.tbm.add((IContributionItem)cc);
        this.tbm.update(true);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.hibernate.eclipse.console.hql"});
    }

    public QueryInputModel getQueryInputModel() {
        return this.queryInputModel;
    }

    public void showConnected(IEditorPart editor) {
        this.defPartName = this.getPartName();
        this.defTitleImage = this.getTitleImage();
        this.setPartName(String.valueOf(this.defPartName) + "->" + editor.getTitle());
        if (this.connectedTitleImage == null) {
            this.connectedTitleImage = HibernateConsolePlugin.getImageDescriptor(this.getConnectedImageFilePath()).createImage();
        }
        this.setTitleImage(this.connectedTitleImage);
    }

    public void showDisconnected() {
        this.setPartName(this.defPartName);
        if (this.defTitleImage != null && !this.defTitleImage.isDisposed()) {
            this.setTitleImage(this.defTitleImage);
        } else {
            this.setTitleImage(null);
        }
        this.connectedTitleImage.dispose();
    }

    protected abstract String getConnectedImageFilePath();
}

