/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.KnownConfigurationsListener;
import org.hibernate.eclipse.console.ComboContribution;
import org.hibernate.eclipse.console.QueryEditor;

final class ConfigurationCombo
extends ComboContribution {
    private KnownConfigurationsListener listener;
    private SelectionAdapter selectionAdapter;
    private QueryEditor editor;

    protected ConfigurationCombo(String id, QueryEditor qe) {
        super(id);
        this.editor = qe;
    }

    protected Control createControl(Composite parent) {
        this.selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationCombo.this.editor.setConsoleConfigurationName(ConfigurationCombo.this.comboControl.getText());
            }
        };
        Control control = super.createControl(parent);
        this.listener = new KnownConfigurationsListener(){

            public void sessionFactoryClosing(ConsoleConfiguration configuration, SessionFactory closingFactory) {
            }

            public void sessionFactoryBuilt(ConsoleConfiguration ccfg, SessionFactory builtFactory) {
            }

            public void configurationRemoved(ConsoleConfiguration root, boolean forUpdate) {
                ConfigurationCombo.this.populateComboBox();
            }

            public void configurationAdded(ConsoleConfiguration root) {
                ConfigurationCombo.this.populateComboBox();
            }
        };
        KnownConfigurations.getInstance().addConsoleConfigurationListener(this.listener);
        return control;
    }

    protected void populateComboBox() {
        ConsoleConfiguration[] configurations = KnownConfigurations.getInstance().getConfigurationsSortedByName();
        final String[] names = new String[configurations.length];
        int i = 0;
        while (i < configurations.length) {
            names[i] = configurations[i].getName();
            ++i;
        }
        final String name = this.editor.getConsoleConfigurationName() == null ? "" : this.editor.getConsoleConfigurationName();
        this.comboControl.getDisplay().syncExec(new Runnable(){

            public void run() {
                ConfigurationCombo.this.comboControl.setItems(names);
                ConfigurationCombo.this.comboControl.setText(name);
                ConfigurationCombo.this.editor.setConsoleConfigurationName(ConfigurationCombo.this.comboControl.getText());
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            KnownConfigurations.getInstance().removeConfigurationListener(this.listener);
        }
    }

    protected SelectionListener getSelectionAdapter() {
        return this.selectionAdapter;
    }
}

