/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.preferences.AbstractConsoleConfigurationPreferences;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.utils.ClassLoaderHelper;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EclipseConsoleConfigurationPreferences
extends AbstractConsoleConfigurationPreferences {
    private IPath cfgFile;
    private IPath propertyFilename;
    private IPath[] mappings = new IPath[0];
    private IPath[] customClasspath = new IPath[0];

    public EclipseConsoleConfigurationPreferences(String configName, ConsoleConfigurationPreferences.ConfigurationMode cmode, String projectName, boolean useProjectClasspath, String entityResolver, IPath cfgFile, IPath propertyFilename, IPath[] mappings, IPath[] classpaths, String persistenceUnitName, String namingStrategy) {
        super(configName, cmode, projectName, useProjectClasspath, entityResolver, persistenceUnitName, namingStrategy);
        this.cfgFile = cfgFile;
        this.propertyFilename = propertyFilename;
        this.mappings = mappings;
        this.customClasspath = classpaths;
    }

    public IPath getCfgFile() {
        return this.cfgFile;
    }

    public IPath getPropertyFilename() {
        return this.propertyFilename;
    }

    public IPath[] getMappings() {
        return this.mappings;
    }

    public IPath[] getCustomClasspath() {
        return this.customClasspath;
    }

    protected EclipseConsoleConfigurationPreferences() {
    }

    public URL[] getCustomClassPathURLS() {
        try {
            IJavaProject project = ProjectUtils.findJavaProject(this.getProjectName());
            String[] additonal = new String[]{};
            if (project != null && this.useProjectClasspath() && project.exists()) {
                try {
                    additonal = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
                }
                catch (CoreException coreException) {
                    throw new HibernateConsoleRuntimeException("Could not compute default classpath from project " + project);
                }
            }
            URL[] rawLocationsURLForResources = ClassLoaderHelper.getRawLocationsURLForResources(this.customClasspath);
            URL[] result = new URL[rawLocationsURLForResources.length + additonal.length];
            int i = 0;
            while (i < rawLocationsURLForResources.length) {
                result[i] = rawLocationsURLForResources[i];
                ++i;
            }
            i = 0;
            while (i < additonal.length) {
                String url = additonal[i];
                result[i + rawLocationsURLForResources.length] = new File(url).toURL();
                ++i;
            }
            return result;
        }
        catch (MalformedURLException mue) {
            throw new HibernateConsoleRuntimeException("Could not resolve classpaths", (Throwable)mue);
        }
    }

    public File[] getMappingFiles() {
        File[] files = new File[this.mappings.length];
        int i = 0;
        while (i < this.mappings.length) {
            IPath path = this.mappings[i];
            files[i] = this.pathToFile(path);
            ++i;
        }
        return files;
    }

    private File pathToFile(IPath path) {
        if (path == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        return this.pathToFile(path.toString(), resource);
    }

    private File pathToFile(String path, IResource resource) {
        IPath rawLocation;
        if (resource != null && (rawLocation = resource.getRawLocation()) != null) {
            return rawLocation.toFile();
        }
        throw new HibernateConsoleRuntimeException("Could not resolve " + path + " to a file");
    }

    public File getConfigXMLFile() {
        return this.pathToFile(this.cfgFile);
    }

    public File getPropertyFile() {
        return this.pathToFile(this.propertyFilename);
    }

    public void writeStateTo(Element node) {
        EclipseConsoleConfigurationPreferences.writeStateTo((Node)node, (String)this.getName(), (String)this.getEntityResolverName(), (ConsoleConfigurationPreferences.ConfigurationMode)this.getConfigurationMode(), (String)this.getProjectName(), (boolean)this.useProjectClasspath(), (Object)this.cfgFile, (Object)this.propertyFilename, (Object[])this.mappings, (Object[])this.customClasspath);
    }

    protected void setConfigFile(String cfgFile) {
        this.cfgFile = cfgFile == null ? null : new Path(cfgFile);
    }

    protected void setPropertyFile(String cfgFile) {
        this.propertyFilename = cfgFile == null ? null : new Path(cfgFile);
    }

    protected void setMappings(String[] mappings) {
        this.mappings = new IPath[mappings.length];
        int i = 0;
        while (i < mappings.length) {
            String cfr_ignored_0 = mappings[i];
            this.mappings[i] = new Path(mappings[i]);
            ++i;
        }
    }

    protected void setCustomClassPath(String[] mappings) {
        this.customClasspath = new IPath[mappings.length];
        int i = 0;
        while (i < mappings.length) {
            this.customClasspath[i] = new Path(mappings[i]);
            ++i;
        }
    }

    public static EclipseConsoleConfigurationPreferences[] readStateFrom(File f) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(f);
            Element root = doc.getDocumentElement();
            NodeList elementsByTagName = root.getElementsByTagName("configuration");
            EclipseConsoleConfigurationPreferences[] result = new EclipseConsoleConfigurationPreferences[elementsByTagName.getLength()];
            int i = 0;
            while (i < elementsByTagName.getLength()) {
                result[i] = new EclipseConsoleConfigurationPreferences();
                result[i].readStateFrom((Element)elementsByTagName.item(i));
                ++i;
            }
            return result;
        }
        catch (SAXException sa) {
            throw new HibernateConsoleRuntimeException("Errors while parsing " + f, (Throwable)sa);
        }
        catch (ParserConfigurationException e) {
            throw new HibernateConsoleRuntimeException("Errors while parsing " + f, (Throwable)e);
        }
        catch (IOException e) {
            throw new HibernateConsoleRuntimeException("Errors while parsing " + f, (Throwable)e);
        }
    }
}

