/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;

public class AddConfigurationAction
extends Action {
    public static final String TEMPORARY_CONFIG_FLAG = "_TEMPORARY_CONFIG_";
    private final IViewPart part;

    public AddConfigurationAction(IViewPart part) {
        this.part = part;
        this.setText("Add Configuration...");
        this.setImageDescriptor(EclipseImages.getImageDescriptor("ADD"));
    }

    public void run() {
        this.doAddConfiguration();
    }

    protected void doAddConfiguration() {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.hibernate.eclipse.launch.ConsoleConfigurationLaunchConfigurationType");
            String launchName = launchManager.generateUniqueLaunchConfigurationNameFrom("hibernate");
            ILaunchConfigurationWorkingCopy wc = launchConfigurationType.newInstance(null, launchName);
            wc.setAttribute(TEMPORARY_CONFIG_FLAG, true);
            ILaunchConfiguration saved = wc.doSave();
            int res = DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)this.part.getSite().getShell(), (ILaunchConfiguration)saved, (String)"org.eclipse.debug.ui.launchGroup.run");
            ArrayList<ILaunchConfiguration> listTempConfigs = new ArrayList<ILaunchConfiguration>();
            ILaunchConfiguration[] configs = launchManager.getLaunchConfigurations(launchConfigurationType);
            int i = 0;
            while (i < configs.length) {
                boolean temporary = configs[i].getAttribute(TEMPORARY_CONFIG_FLAG, false);
                if (temporary) {
                    listTempConfigs.add(configs[i]);
                }
                ++i;
            }
            if (res != 0) {
                i = 0;
                while (i < listTempConfigs.size()) {
                    ((ILaunchConfiguration)listTempConfigs.get(i)).delete();
                    ++i;
                }
            } else {
                i = 0;
                while (i < listTempConfigs.size()) {
                    wc = ((ILaunchConfiguration)listTempConfigs.get(i)).getWorkingCopy();
                    wc.setAttribute(TEMPORARY_CONFIG_FLAG, null);
                    wc.doSave();
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().showError(this.part.getSite().getShell(), "Problem adding a console configuration", ce);
        }
    }
}

