/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AutoResizeTableLayout
extends TableLayout
implements ControlListener {
    private final Table table;
    private List columns = new ArrayList();
    private boolean autosizing = false;

    public AutoResizeTableLayout(Table table) {
        this.table = table;
        table.addControlListener((ControlListener)this);
    }

    public void addColumnData(ColumnLayoutData data) {
        this.columns.add(data);
        super.addColumnData(data);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.autosizing) {
            return;
        }
        this.autosizing = true;
        try {
            this.autoSizeColumns();
        }
        finally {
            this.autosizing = false;
        }
    }

    private void autoSizeColumns() {
        int width = this.table.getClientArea().width;
        if (width <= 1) {
            return;
        }
        TableColumn[] tableColumns = this.table.getColumns();
        int size = Math.min(this.columns.size(), tableColumns.length);
        int[] widths = new int[size];
        int fixedWidth = 0;
        int numberOfWeightColumns = 0;
        int totalWeight = 0;
        int i = 0;
        while (i < size) {
            ColumnLayoutData col = (ColumnLayoutData)this.columns.get(i);
            if (col instanceof ColumnPixelData) {
                int pixels;
                widths[i] = pixels = ((ColumnPixelData)col).width;
                fixedWidth += pixels;
            } else if (col instanceof ColumnWeightData) {
                ColumnWeightData cw = (ColumnWeightData)col;
                ++numberOfWeightColumns;
                int weight = cw.weight;
                totalWeight += weight;
            } else {
                throw new IllegalStateException("Unknown column layout data");
            }
            ++i;
        }
        if (numberOfWeightColumns > 0) {
            int rest = width - fixedWidth;
            int totalDistributed = 0;
            int i2 = 0;
            while (i2 < size) {
                ColumnLayoutData col = (ColumnLayoutData)this.columns.get(i2);
                if (col instanceof ColumnWeightData) {
                    ColumnWeightData cw = (ColumnWeightData)col;
                    int weight = cw.weight;
                    int pixels = totalWeight == 0 ? 0 : weight * rest / totalWeight;
                    totalDistributed += pixels;
                    widths[i2] = pixels;
                }
                ++i2;
            }
            int diff = rest - totalDistributed;
            int i3 = 0;
            while (diff > 0) {
                ColumnLayoutData col;
                if (i3 == size) {
                    i3 = 0;
                }
                if ((col = (ColumnLayoutData)this.columns.get(i3)) instanceof ColumnWeightData) {
                    int n = i3;
                    widths[n] = widths[n] + 1;
                    --diff;
                }
                ++i3;
            }
        }
        i = 0;
        while (i < size) {
            if (tableColumns[i].getWidth() != widths[i]) {
                tableColumns[i].setWidth(widths[i]);
            }
            ++i;
        }
    }
}

