/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.hibernate.console.HibernateConsoleRuntimeException;

public class ClassLoaderHelper {
    public static URLClassLoader getProjectClassLoader(IJavaProject project) {
        List pathElements = ClassLoaderHelper.getProjectClassPathURLs(project);
        URL[] urlPaths = pathElements.toArray(new URL[pathElements.size()]);
        return new URLClassLoader(urlPaths, Thread.currentThread().getContextClassLoader());
    }

    public static List getProjectClassPathURLs(IJavaProject project) {
        ArrayList<URL> pathElements = new ArrayList<URL>();
        try {
            IClasspathEntry[] paths = project.getResolvedClasspath(true);
            if (paths != null) {
                int i = 0;
                while (i < paths.length) {
                    IClasspathEntry path = paths[i];
                    if (path.getEntryKind() == 1) {
                        IPath simplePath = path.getPath();
                        URL url = ClassLoaderHelper.getRawLocationURL(simplePath);
                        pathElements.add(url);
                    }
                    ++i;
                }
            }
            IPath location = ClassLoaderHelper.getProjectLocation(project.getProject());
            IPath outputPath = location.append(project.getOutputLocation().removeFirstSegments(1));
            pathElements.add(outputPath.toFile().toURL());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return pathElements;
    }

    private static URL getRawLocationURL(IPath simplePath) throws MalformedURLException {
        File file = ClassLoaderHelper.getRawLocationFile(simplePath);
        return file.toURL();
    }

    private static File getRawLocationFile(IPath simplePath) {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(simplePath);
        File file = null;
        if (member != null) {
            IPath rawLocation = member.getRawLocation();
            if (rawLocation == null && (rawLocation = member.getLocation()) == null) {
                throw new HibernateConsoleRuntimeException("Could not determine physical location for " + simplePath);
            }
            file = rawLocation.toFile();
        } else {
            file = simplePath.toFile();
        }
        return file;
    }

    public static IPath getProjectLocation(IProject project) {
        if (project.getRawLocation() == null) {
            return project.getLocation();
        }
        return project.getRawLocation();
    }

    public static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    public static URL[] getRawLocationsURLForResources(IPath[] classpaths) throws MalformedURLException {
        URL[] l = new URL[classpaths.length];
        int i = 0;
        while (i < classpaths.length) {
            l[i] = ClassLoaderHelper.getRawLocationURL(classpaths[i]);
            ++i;
        }
        return l;
    }

    public static String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<String> userEntries = new ArrayList<String>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String location;
            IRuntimeClasspathEntry runtimeClasspathEntry = entries[i];
            if (runtimeClasspathEntry.getClasspathProperty() == 3 && (location = runtimeClasspathEntry.getLocation()) != null) {
                userEntries.add(location);
            }
            ++i;
        }
        return userEntries.toArray(new String[userEntries.size()]);
    }
}

