/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public class DialogSelectionHelper
extends org.hibernate.eclipse.console.utils.xpl.DialogSelectionHelper {
    public static IJavaProject chooseJavaProject(Shell shell, IJavaProject initialSelection, String title, String description) {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            HibernateConsolePlugin.getDefault().log(e.getStatus());
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.setElements(projects);
        IJavaProject javaProject = initialSelection;
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    public static String chooseImplementation(String supertype, String initialSelection, String title, Shell shell) {
        SelectionDialog dialog = null;
        try {
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)supertype);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        dialog.setTitle(title);
        dialog.setMessage(title);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            return type.getFullyQualifiedName('.');
        }
        return null;
    }
}

