/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.launch.IConsoleConfigurationLaunchConstants;
import org.hibernate.util.StringHelper;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectUtils {
    private ProjectUtils() {
    }

    public static boolean toggleHibernateOnProject(IProject project, boolean enable, String defaultConsoleName) {
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
        if (node != null) {
            node.putBoolean("hibernate3.enabled", enable);
            node.put("default.configuration", defaultConsoleName);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Could not save changes to preferences", e);
                return false;
            }
        } else {
            return false;
        }
        try {
            if (enable) {
                return ProjectUtils.addProjectNature(project, "org.hibernate.eclipse.console.hibernateNature", (IProgressMonitor)new NullProgressMonitor());
            }
            return ProjectUtils.removeProjectNature(project, "org.hibernate.eclipse.console.hibernateNature", new NullProgressMonitor());
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Could not activate Hibernate nature on project " + project.getName(), ce);
            HibernateConsolePlugin.getDefault().log(ce.getStatus());
            return false;
        }
    }

    public static boolean addProjectNature(IProject project, String nature, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature(nature)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = nature;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
            return true;
        }
        monitor.worked(1);
        return false;
    }

    public static boolean removeProjectNature(IProject project, String nature, NullProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (project.hasNature(nature)) {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length - 1];
            int i = 0;
            while (i < natures.length) {
                if (!natures[i].equals(nature)) {
                    newNatures[i] = natures[i];
                }
                ++i;
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)monitor);
            return true;
        }
        monitor.worked(1);
        return false;
    }

    public static IJavaProject findJavaProject(IEditorPart part) {
        if (part != null) {
            return ProjectUtils.findJavaProject(part.getEditorInput());
        }
        return null;
    }

    public static IJavaProject findJavaProject(IEditorInput input) {
        if (input != null && input instanceof IFileEditorInput) {
            IFile file = null;
            IProject project = null;
            IJavaProject jProject = null;
            IFileEditorInput fileInput = (IFileEditorInput)input;
            file = fileInput.getFile();
            project = file.getProject();
            jProject = JavaCore.create((IProject)project);
            return jProject;
        }
        return null;
    }

    public static IJavaProject findJavaProject(String name) {
        if (StringHelper.isEmpty((String)name)) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = null;
        project = root.getProject(name);
        if (project != null) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static IJavaProject findJavaProject(ConsoleConfiguration consoleConfiguration) {
        IJavaProject proj = null;
        if (consoleConfiguration != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.hibernate.eclipse.launch.ConsoleConfigurationLaunchConfigurationType");
            try {
                ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
                int i = 0;
                while (i < launchConfigurations.length) {
                    ILaunchConfiguration launchConfiguration = launchConfigurations[i];
                    if (launchConfiguration.getName().equals(consoleConfiguration.getName())) {
                        proj = ProjectUtils.findJavaProject(launchConfiguration.getAttribute(IConsoleConfigurationLaunchConstants.PROJECT_NAME, ""));
                    }
                    ++i;
                }
            }
            catch (CoreException e1) {
                HibernateConsolePlugin.getDefault().log(e1);
            }
        }
        return proj;
    }
}

