/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.EclipseConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.eclipse.console.wizards.ConsoleConfigurationWizardPage;
import org.hibernate.eclipse.launch.IConsoleConfigurationLaunchConstants;
import org.hibernate.eclipse.nature.HibernateNature;
import org.hibernate.util.StringHelper;

public class ConsoleConfigurationCreationWizard
extends Wizard
implements INewWizard {
    private ConsoleConfigurationWizardPage page;
    private ISelection selection;

    public ConsoleConfigurationCreationWizard() {
        this.setDefaultPageImageDescriptor(EclipseImages.getImageDescriptor("NEW_WIZARD"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new ConsoleConfigurationWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        ConsoleConfigurationWizardPage confPage = this.page;
        return ConsoleConfigurationCreationWizard.createConsoleConfiguration(this.getContainer(), confPage);
    }

    static boolean createConsoleConfiguration(IWizardContainer container, final ConsoleConfigurationWizardPage confPage) {
        final String configName = confPage.getConfigurationName();
        final String entityResolver = confPage.getEntityResolverClassName();
        Path propertyFile = confPage.getPropertyFilePath();
        Path fileName = confPage.getConfigurationFilePath();
        final ConsoleConfigurationPreferences.ConfigurationMode annotations = confPage.getConfigurationMode();
        IPath[] mappings = confPage.getMappingFiles();
        IPath[] classpaths = confPage.getClassPath();
        final boolean useProjectClasspath = confPage.useProjectClassPath();
        final String projectName = confPage.getProjectName();
        String namingStrategy = confPage.getNamingStrategy();
        String persistenceUnitName = confPage.getPersistenceUnitName();
        IRunnableWithProgress op = new IRunnableWithProgress((IPath)propertyFile, (IPath)fileName, mappings, classpaths, persistenceUnitName, namingStrategy){
            private final /* synthetic */ IPath val$propertyFile;
            private final /* synthetic */ IPath val$fileName;
            private final /* synthetic */ IPath[] val$mappings;
            private final /* synthetic */ IPath[] val$classpaths;
            private final /* synthetic */ String val$persistenceUnitName;
            private final /* synthetic */ String val$namingStrategy;
            {
                this.val$propertyFile = iPath;
                this.val$fileName = iPath2;
                this.val$mappings = iPathArray;
                this.val$classpaths = iPathArray2;
                this.val$persistenceUnitName = string4;
                this.val$namingStrategy = string5;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        ConsoleConfigurationCreationWizard.createConsoleConfiguration(confPage.getShell(), confPage.getOldConfiguration(), configName, annotations, projectName, useProjectClasspath, entityResolver, this.val$propertyFile, this.val$fileName, this.val$mappings, this.val$classpaths, this.val$persistenceUnitName, this.val$namingStrategy, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            container.run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            IStatus s = null;
            if (realException instanceof CoreException) {
                s = ((CoreException)realException).getStatus();
            } else {
                IStatus se = HibernateConsolePlugin.throwableToStatus(e);
                s = new MultiStatus("org.hibernate.eclipse.console", 0, new IStatus[]{se}, "Probably missing classes or errors with classloading", (Throwable)e);
            }
            HibernateConsolePlugin.getDefault().showError(container.getShell(), "Error while finishing Wizard", s);
            return false;
        }
        return true;
    }

    protected static void createConsoleConfiguration(final Shell shell, final EclipseConsoleConfiguration oldConfig, final String configName, ConsoleConfigurationPreferences.ConfigurationMode cmode, final String projectName, boolean useProjectClasspath, String entityResolver, IPath propertyFilename, IPath cfgFile, IPath[] mappings, IPath[] classpaths, String persistenceUnitName, String namingStrategy, IProgressMonitor monitor) throws CoreException {
        int i;
        monitor.beginTask("Configuring Hibernate Console", -1);
        if (oldConfig != null) {
            KnownConfigurations.getInstance().removeConfiguration((ConsoleConfiguration)oldConfig, false);
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.hibernate.eclipse.launch.ConsoleConfigurationLaunchConfigurationType");
        String launchName = launchManager.generateUniqueLaunchConfigurationNameFrom(configName);
        ILaunchConfigurationWorkingCopy wc = launchConfigurationType.newInstance(null, launchName);
        wc.setAttribute("org.hibernate.eclipse.launch.CONFIGURATION_FACTORY", cmode.toString());
        wc.setAttribute(IConsoleConfigurationLaunchConstants.PROJECT_NAME, projectName);
        wc.setAttribute("org.hibernate.eclipse.launch.PROPERTY_FILE", ConsoleConfigurationCreationWizard.safePathName(propertyFilename));
        wc.setAttribute("org.hibernate.eclipse.launch.CFG_XML_FILE", ConsoleConfigurationCreationWizard.safePathName(cfgFile));
        wc.setAttribute("org.hibernate.eclipse.launch.PERSISTENCE_UNIT_NAME", persistenceUnitName);
        wc.setAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", namingStrategy);
        wc.setAttribute("org.hibernate.eclipse.launchENTITY_RESOLVER", entityResolver);
        IRuntimeClasspathEntry[] projectEntries = new IRuntimeClasspathEntry[]{};
        if (useProjectClasspath) {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            projectEntries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)wc);
        }
        if (classpaths.length > 0) {
            ArrayList<String> user = new ArrayList<String>();
            i = 0;
            while (i < projectEntries.length) {
                user.add(projectEntries[i].getMemento());
                ++i;
            }
            i = 0;
            while (i < classpaths.length) {
                IPath entry = classpaths[i];
                IRuntimeClasspathEntry userEntry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry);
                user.add(userEntry.getMemento());
                ++i;
            }
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, user);
        } else {
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
        }
        ArrayList<String> mappingFiles = new ArrayList<String>();
        i = 0;
        while (i < mappings.length) {
            mappingFiles.add(mappings[i].toPortableString());
            ++i;
        }
        wc.setAttribute("org.hibernate.eclipse.launch.FILE_MAPPINGS", mappingFiles);
        wc.doSave();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IJavaProject project;
                if (StringHelper.isNotEmpty((String)projectName) && (project = ProjectUtils.findJavaProject(projectName)).exists()) {
                    HibernateNature hibernateNature = HibernateNature.getHibernateNature(project);
                    if (hibernateNature == null) {
                        if (MessageDialog.openConfirm((Shell)shell, (String)"Enable Hibernate features for project", (String)("The project named '" + projectName + "' does not have Hibernate features enabled. Should it be updated to use " + configName + " ?"))) {
                            ProjectUtils.toggleHibernateOnProject(project.getProject(), true, configName);
                        }
                    } else {
                        String defaultConsoleConfigurationName = hibernateNature.getDefaultConsoleConfigurationName();
                        if (oldConfig != null && oldConfig.getName().equals(defaultConsoleConfigurationName) || defaultConsoleConfigurationName.equals(hibernateNature.getDefaultConsoleConfigurationName())) {
                            ProjectUtils.toggleHibernateOnProject(project.getProject(), true, configName);
                        } else if (defaultConsoleConfigurationName == null) {
                            if (MessageDialog.openConfirm((Shell)shell, (String)"Enable Hibernate features for project", (String)("The project named " + projectName + " does not have a default Hibernate configuration specified. Should it be updated to use " + configName + " ?"))) {
                                ProjectUtils.toggleHibernateOnProject(project.getProject(), true, configName);
                            }
                        } else if (MessageDialog.openConfirm((Shell)shell, (String)"Enable Hibernate features for project", (String)("The project named " + projectName + " have the " + defaultConsoleConfigurationName + " specified. Should it be updated to use " + configName + " ?"))) {
                            ProjectUtils.toggleHibernateOnProject(project.getProject(), true, configName);
                        }
                    }
                }
            }
        });
        monitor.worked(1);
    }

    private static String safePathName(IPath propertyFilename) {
        if (propertyFilename == null) {
            return null;
        }
        return propertyFilename.toOSString();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

