/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.hibernate.eclipse.console.utils.DriverClassHelpers;

public class NewConfigurationWizardPage
extends WizardPage {
    private final DriverClassHelpers helper = new DriverClassHelpers();
    private Label containerText;
    private Label fileText;
    private Text sessionFactoryNameText;
    private Combo dialectCombo;
    private Combo driver_classCombo;
    private Text usernameText;
    private Text passwordText;
    private Text defaultSchemaText;
    private Text defaultCatalogText;
    private Combo urlCombo;
    private Button createConsoleConfiguration;
    private ISelection selection;
    private final WizardNewFileCreationPage fileCreation;
    private boolean beenShown = false;

    public NewConfigurationWizardPage(ISelection selection, WizardNewFileCreationPage page) {
        super("wizardPage");
        this.fileCreation = page;
        this.setTitle("Hibernate Configuration File (cfg.xml)");
        this.setDescription("This wizard creates a new configuration file to use with Hibernate.");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationWizardPage.this.dialogChanged();
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewConfigurationWizardPage.this.dialogChanged();
                NewConfigurationWizardPage.this.getContainer().updateButtons();
            }

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationWizardPage.this.dialogChanged();
                NewConfigurationWizardPage.this.getContainer().updateButtons();
            }
        };
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText("&Container:");
        this.containerText = new Label(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("&File name:");
        this.fileText = new Label(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText("&Session factory name:");
        this.sessionFactoryNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.sessionFactoryNameText.setLayoutData((Object)gd);
        this.sessionFactoryNameText.addModifyListener(listener);
        label = new Label(container, 0);
        label.setText("&Database dialect:");
        this.dialectCombo = new Combo(container, 0);
        this.fillHerUp(this.dialectCombo, this.helper.getDialectNames());
        this.dialectCombo.select(0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.dialectCombo.setLayoutData((Object)gd);
        this.dialectCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] driverClasses = NewConfigurationWizardPage.this.helper.getDriverClasses(NewConfigurationWizardPage.this.helper.getDialectClass(NewConfigurationWizardPage.this.dialectCombo.getText()));
                NewConfigurationWizardPage.this.fillHerUp(NewConfigurationWizardPage.this.driver_classCombo, driverClasses);
                NewConfigurationWizardPage.this.dialogChanged();
            }
        });
        gd = new GridData(1, 2, false, false);
        gd.horizontalAlignment = 128;
        gd.verticalAlignment = 128;
        label.setLayoutData((Object)gd);
        Composite driverManagerTabContainer = container;
        label = new Label(driverManagerTabContainer, 0);
        label.setText("&Driver class:");
        this.driver_classCombo = new Combo(driverManagerTabContainer, 0);
        this.driver_classCombo.select(0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.driver_classCombo.setLayoutData((Object)gd);
        this.driver_classCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] connectionURLS = NewConfigurationWizardPage.this.helper.getConnectionURLS(NewConfigurationWizardPage.this.driver_classCombo.getText());
                NewConfigurationWizardPage.this.fillHerUp(NewConfigurationWizardPage.this.urlCombo, connectionURLS);
                NewConfigurationWizardPage.this.dialogChanged();
            }
        });
        label = new Label(driverManagerTabContainer, 0);
        label.setText("Connection &URL:");
        this.urlCombo = new Combo(driverManagerTabContainer, 0);
        this.urlCombo.select(0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.urlCombo.setLayoutData((Object)gd);
        this.urlCombo.addModifyListener(listener);
        label = new Label(driverManagerTabContainer, 0);
        label.setText("Default Schema:");
        this.defaultSchemaText = new Text(driverManagerTabContainer, 2052);
        gd = new GridData(768);
        this.defaultSchemaText.setLayoutData((Object)gd);
        this.defaultSchemaText.addModifyListener(listener);
        label = new Label(driverManagerTabContainer, 0);
        label.setText("Default Catalog:");
        this.defaultCatalogText = new Text(driverManagerTabContainer, 2052);
        gd = new GridData(768);
        this.defaultCatalogText.setLayoutData((Object)gd);
        this.defaultCatalogText.addModifyListener(listener);
        label = new Label(driverManagerTabContainer, 0);
        label.setText("User&name:");
        this.usernameText = new Text(driverManagerTabContainer, 2052);
        gd = new GridData(768);
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.addModifyListener(listener);
        label = new Label(driverManagerTabContainer, 0);
        label.setText("&Password:");
        this.passwordText = new Text(driverManagerTabContainer, 2052);
        gd = new GridData(768);
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(listener);
        this.fillLabel(container);
        this.fillLabel(container);
        this.fillLabel(container);
        this.createConsoleConfiguration = new Button(container, 32);
        gd = new GridData(768);
        this.createConsoleConfiguration.setLayoutData((Object)gd);
        this.createConsoleConfiguration.setText("Create a console configuration");
        this.createConsoleConfiguration.addSelectionListener(selectionListener);
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void fillHerUp(Combo combo, String[] newContent) {
        String original = combo.getText();
        combo.removeAll();
        int i = 0;
        while (i < newContent.length) {
            String name = newContent[i];
            combo.add(name);
            ++i;
        }
        combo.setText(original);
    }

    private void fillLabel(Composite container) {
        new Label(container, 0);
    }

    private void initialize() {
        this.updateStatus(null);
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus("File container must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus("File container must exist");
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus("Project must be writable");
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus("File name must be specified");
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus("File name must be valid");
            return;
        }
        if (!fileName.endsWith(".cfg.xml")) {
            this.updateStatus("File extension must be \"cfg.xml\"");
            return;
        }
        IFile file = ((IContainer)container).getFile((IPath)new Path(fileName));
        if (file.exists()) {
            this.updateStatus("File already exists");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null && this.beenShown);
    }

    private String getContainerName() {
        return this.containerText.getText();
    }

    private String getFileName() {
        return this.fileText.getText();
    }

    public String getSessionFactoryName() {
        return this.nullIfEmpty(this.sessionFactoryNameText.getText());
    }

    private String nullIfEmpty(String text) {
        if (text != null && text.trim().length() > 0) {
            return text.trim();
        }
        return null;
    }

    public String getDialect() {
        return this.nullIfEmpty(this.helper.getDialectClass(this.dialectCombo.getText()));
    }

    public String getDriver() {
        return this.nullIfEmpty(this.driver_classCombo.getText());
    }

    public String getConnectionURL() {
        return this.nullIfEmpty(this.urlCombo.getText());
    }

    public String getUsername() {
        return this.nullIfEmpty(this.usernameText.getText());
    }

    public String getPassword() {
        return this.nullIfEmpty(this.passwordText.getText());
    }

    public void setVisible(boolean visible) {
        this.containerText.setText(this.fileCreation.getContainerFullPath().toPortableString());
        this.fileText.setText(this.fileCreation.getFileName());
        super.setVisible(visible);
        if (visible) {
            this.sessionFactoryNameText.setFocus();
        }
        this.beenShown = true;
        this.dialogChanged();
    }

    public boolean isCreateConsoleConfigurationEnabled() {
        return this.createConsoleConfiguration.getSelection();
    }

    public void setCreateConsoleConfigurationVisible(boolean isVisible) {
        if (this.createConsoleConfiguration != null) {
            this.createConsoleConfiguration.setVisible(isVisible);
        }
    }

    public String getDefaultCatalog() {
        return this.nullIfEmpty(this.defaultCatalogText.getText());
    }

    public String getDefaultSchema() {
        return this.nullIfEmpty(this.defaultSchemaText.getText());
    }
}

