/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.xpl.SelectionHelper;
import org.hibernate.eclipse.console.wizards.NewHibernateMappingFilePage;
import org.hibernate.util.StringHelper;

public class NewHibernateMappingFileWizard
extends Wizard
implements INewWizard {
    private NewHibernateMappingFilePage mappingFileInfoPage;
    private ISelection selection;
    private WizardNewFileCreationPage cPage;

    public NewHibernateMappingFileWizard() {
        this.setDefaultPageImageDescriptor(EclipseImages.getImageDescriptor("NEW_WIZARD"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.cPage = new ExtendedWizardNewFileCreationPage("Chbmxml", (IStructuredSelection)this.selection);
        this.cPage.setTitle("Create Hibernate XML Mapping file (hbm.xml)");
        this.cPage.setDescription("Create a new XML Mapping file.");
        IType initialJavaElement = SelectionHelper.getClassFromElement(SelectionHelper.getInitialJavaElement(this.selection));
        if (initialJavaElement != null) {
            this.cPage.setFileName(String.valueOf(initialJavaElement.getElementName()) + ".hbm.xml");
        } else {
            this.cPage.setFileName("NewMapping.hbm.xml");
        }
        this.addPage((IWizardPage)this.cPage);
        this.mappingFileInfoPage = new NewHibernateMappingFilePage(this.selection, this.cPage);
        this.addPage((IWizardPage)this.mappingFileInfoPage);
    }

    public boolean performFinish() {
        final IFile file = this.cPage.createNewFile();
        final String classToMapText = this.mappingFileInfoPage.getClassToMapText();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewHibernateMappingFileWizard.this.createFile(file, classToMapText, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            HibernateConsolePlugin.getDefault().log(realException);
            return false;
        }
        return true;
    }

    private void createFile(final IFile file, String classToMapText, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + file.getName(), 2);
        try {
            InputStream stream = this.openContentStream(classToMapText);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(String classToMapText) {
        String classname = null;
        String packagename = null;
        if (StringHelper.isNotEmpty((String)classToMapText)) {
            classname = StringHelper.unqualify((String)classToMapText);
            packagename = StringHelper.qualifier((String)classToMapText);
        }
        String contents = "<?xml version=\"1.0\"?>\n<!DOCTYPE hibernate-mapping PUBLIC\n\t\"-//Hibernate/Hibernate Mapping DTD 3.0//EN\"\n\t\"http://hibernate.sourceforge.net/hibernate-mapping-3.0.dtd\">\n<hibernate-mapping";
        contents = StringHelper.isNotEmpty(packagename) ? String.valueOf(contents) + " package=\"" + packagename + "\">" : String.valueOf(contents) + ">\n";
        if (StringHelper.isNotEmpty((String)classname)) {
            contents = String.valueOf(contents) + "\n  <class name=\"" + classname + "\">\n" + "  </class>";
        }
        contents = String.valueOf(contents) + "\n</hibernate-mapping>";
        return new ByteArrayInputStream(contents.getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    static class ExtendedWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        boolean firstTime = true;

        public ExtendedWizardNewFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (this.firstTime) {
                this.validatePage();
                this.firstTime = false;
            }
        }
    }
}

