/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class UpDownListComposite
extends Composite {
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            UpDownListComposite.this.handleButtonPressed((Button)e.widget);
        }
    };
    private Group group = null;
    private Table table = null;
    private Composite buttons = null;
    private Button removeButton = null;
    private Button upButton = null;
    private Button downButton = null;
    private Label fillLabel = null;
    private Button[] addButtons;
    private TableViewer tableView;
    private IBaseLabelProvider provider = null;
    private final String title;
    private final boolean checkboxInTable;
    private IContentProvider contentProvider;

    public UpDownListComposite(Composite parent, int style) {
        this(parent, style, "");
    }

    public UpDownListComposite(Composite parent, int style, String title) {
        this(parent, style, title, false, null, null);
    }

    public UpDownListComposite(Composite parent, int style, String title, boolean checkboxInTable, IBaseLabelProvider provider, IContentProvider contentProvider) {
        super(parent, style);
        this.title = title;
        this.checkboxInTable = checkboxInTable;
        this.provider = provider;
        this.contentProvider = contentProvider;
        this.initialize();
    }

    private void initialize() {
        this.createGroup();
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
    }

    private void createGroup() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.group = new Group((Composite)this, 0);
        this.group.setText(this.title);
        this.createTable();
        this.group.setLayoutData((Object)gridData);
        this.group.setLayout((Layout)gridLayout);
        this.createButtons();
    }

    private void createTable() {
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalAlignment = 4;
        gridData1.heightHint = 20;
        gridData1.widthHint = 20;
        this.table = new Table((Composite)this.group, 0x10802 | (this.checkboxInTable ? 32 : 0));
        this.table.setHeaderVisible(false);
        this.table.setLayoutData((Object)gridData1);
        this.table.setLinesVisible(false);
        this.createColumns(this.table);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                UpDownListComposite.this.handleTableSelectionChanged();
            }

            public void widgetSelected(SelectionEvent e) {
                UpDownListComposite.this.handleTableSelectionChanged();
            }
        });
        Object object = this.tableView = this.checkboxInTable ? new CheckboxTableViewer(this.table) : new TableViewer(this.table);
        if (this.provider != null) {
            this.tableView.setLabelProvider(this.provider);
        }
        if (this.contentProvider != null) {
            this.tableView.setContentProvider(this.contentProvider);
        }
    }

    protected void createColumns(Table table) {
    }

    private void createButtons() {
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        gridData6.verticalAlignment = 2;
        GridData gridData5 = new GridData();
        gridData5.horizontalAlignment = 4;
        gridData5.verticalAlignment = 2;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = false;
        gridData2.grabExcessVerticalSpace = false;
        gridData2.verticalAlignment = 4;
        this.buttons = new Composite((Composite)this.group, 0);
        this.buttons.setLayout((Layout)new GridLayout());
        this.buttons.setLayoutData((Object)gridData2);
        String[] addButtonLabels = this.getAddButtonLabels();
        this.addButtons = new Button[addButtonLabels.length];
        int i = 0;
        while (i < addButtonLabels.length) {
            String label = addButtonLabels[i];
            this.addButtons[i] = this.createButton(this.buttons, label);
            this.addButtons[i].setEnabled(true);
            ++i;
        }
        this.removeButton = new Button(this.buttons, 0);
        this.removeButton.setText("Remove");
        this.removeButton.setLayoutData((Object)gridData3);
        this.removeButton.addSelectionListener(this.buttonListener);
        this.fillLabel = new Label(this.buttons, 0);
        this.fillLabel.setText("");
        this.fillLabel.setLayoutData((Object)gridData6);
        this.upButton = new Button(this.buttons, 0);
        this.upButton.setText("Up");
        this.upButton.setLayoutData((Object)gridData4);
        this.upButton.addSelectionListener(this.buttonListener);
        this.downButton = new Button(this.buttons, 0);
        this.downButton.setText("Down");
        this.downButton.setLayoutData((Object)gridData5);
        this.downButton.addSelectionListener(this.buttonListener);
    }

    protected String[] getAddButtonLabels() {
        return new String[]{"Add..."};
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        button.setText(label);
        button.setEnabled(false);
        button.addSelectionListener(this.buttonListener);
        return button;
    }

    private void handleButtonPressed(Button button) {
        if (button == this.removeButton) {
            this.handleRemove();
        } else if (button == this.upButton) {
            this.moveSelectionUp();
        } else if (button == this.downButton) {
            this.moveSelectionDown();
        } else {
            int i = 0;
            while (i < this.addButtons.length) {
                Button but = this.addButtons[i];
                if (button == but) {
                    this.handleAddButtonPressed(i);
                }
                ++i;
            }
        }
        this.handleTableSelectionChanged();
        this.tableView.getTable().setFocus();
    }

    protected void moveSelectionDown() {
        Table table = this.tableView.getTable();
        int[] indices = table.getSelectionIndices();
        if (indices.length < 1) {
            return;
        }
        int[] newSelection = new int[indices.length];
        int max = table.getItemCount() - 1;
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            if (index < max) {
                this.move(this.tableView, table.getItem(index), index + 1);
                newSelection[i] = index + 1;
            }
            --i;
        }
        table.setSelection(newSelection);
        this.listChanged();
    }

    protected void moveSelectionUp() {
        Table table = this.tableView.getTable();
        int[] indices = table.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index > 0) {
                this.move(this.tableView, table.getItem(index), index - 1);
                newSelection[i] = index - 1;
            }
            ++i;
        }
        table.setSelection(newSelection);
        this.listChanged();
    }

    private void move(TableViewer viewer, TableItem item, int index) {
        Object data = item.getData();
        item.dispose();
        viewer.insert(data, index);
    }

    protected void handleRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.tableView.getSelection();
        if (selection != null) {
            selection.size();
            for (Object item : selection) {
                this.tableView.remove(item);
            }
            this.listChanged();
        }
    }

    private void handleAddButtonPressed(int i) {
        Object[] o = this.handleAdd(i);
        if (o != null) {
            this.add(o, true);
        }
    }

    public void add(Object[] o, boolean notify) {
        this.tableView.add(o);
        if (notify) {
            this.listChanged();
        }
    }

    protected void listChanged() {
    }

    protected Object[] handleAdd(int i) {
        return new Object[]{" test "};
    }

    private void handleTableSelectionChanged() {
        boolean validSelection;
        int i = 0;
        while (i < this.addButtons.length) {
            this.addButtons[i].setEnabled(true);
            ++i;
        }
        Table builderTable = this.tableView.getTable();
        TableItem[] items = builderTable.getSelection();
        boolean enableRemove = validSelection = items != null && items.length > 0;
        boolean enableUp = validSelection;
        boolean enableDown = validSelection;
        if (validSelection) {
            int[] indices = builderTable.getSelectionIndices();
            int max = builderTable.getItemCount();
            enableUp = indices[0] != 0;
            enableDown = indices[indices.length - 1] < max - 1;
            enableRemove = true;
        }
        this.removeButton.setEnabled(enableRemove);
        this.upButton.setEnabled(enableUp);
        this.downButton.setEnabled(enableDown);
    }

    public Table getTable() {
        return this.tableView.getTable();
    }

    public TableViewer getTableViewer() {
        return this.tableView;
    }

    public void clear() {
        this.tableView.getTable().removeAll();
    }
}

