/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.node.BaseNode;
import org.hibernate.eclipse.console.workbench.BaseNodeWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.ColumnWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.ConfigurationWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.ConsoleConfigurationWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.KnownConfigurationsWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchema;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchemaWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.LazySessionFactory;
import org.hibernate.eclipse.console.workbench.LazySessionFactoryAdapter;
import org.hibernate.eclipse.console.workbench.PersistentClassWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.PrimaryKeyWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.PropertyWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.TableContainer;
import org.hibernate.eclipse.console.workbench.TableContainerWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.TableWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.ValueWorkbenchAdapter;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

public class ConfigurationAdapterFactory
implements IAdapterFactory {
    private Class[] classes;
    private IDeferredWorkbenchAdapter[] adapters;

    public ConfigurationAdapterFactory() {
        HashMap<Class<Column>, Object> map = new HashMap<Class<Column>, Object>();
        map.put(ConsoleConfiguration.class, new ConsoleConfigurationWorkbenchAdapter());
        map.put(Configuration.class, new ConfigurationWorkbenchAdapter());
        map.put(KnownConfigurations.class, new KnownConfigurationsWorkbenchAdapter());
        map.put(PersistentClass.class, new PersistentClassWorkbenchAdapter());
        map.put(Property.class, new PropertyWorkbenchAdapter());
        map.put(Value.class, new ValueWorkbenchAdapter());
        map.put(BaseNode.class, new BaseNodeWorkbenchAdapter());
        map.put(LazyDatabaseSchema.class, new LazyDatabaseSchemaWorkbenchAdapter());
        map.put(LazySessionFactory.class, new LazySessionFactoryAdapter());
        map.put(TableContainer.class, new TableContainerWorkbenchAdapter());
        map.put(Table.class, new TableWorkbenchAdapter());
        map.put(PrimaryKey.class, new PrimaryKeyWorkbenchAdapter());
        map.put(Column.class, new ColumnWorkbenchAdapter());
        this.classes = new Class[map.size()];
        this.adapters = new IDeferredWorkbenchAdapter[map.size()];
        Iterator iter = map.entrySet().iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.classes[cnt] = (Class)entry.getKey();
            this.adapters[cnt] = (IDeferredWorkbenchAdapter)entry.getValue();
            ++cnt;
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IDeferredWorkbenchAdapter.class || adapterType == IWorkbenchAdapter.class) {
            return this.getAdapter(adaptableObject);
        }
        if (adapterType == IPropertySource2.class || adapterType == IPropertySource.class) {
            return this.getPropertySource(adaptableObject);
        }
        return null;
    }

    private Object getPropertySource(Object adaptableObject) {
        return null;
    }

    private Object getAdapter(Object adaptableObject) {
        int i = 0;
        while (i < this.classes.length) {
            Class clazz = this.classes[i];
            if (clazz.isInstance(adaptableObject)) {
                return this.adapters[i];
            }
            ++i;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IDeferredWorkbenchAdapter.class, IWorkbenchAdapter.class, IPropertySource.class, IPropertySource2.class};
    }

    public void registerAdapters(IAdapterManager adapterManager) {
        int i = 0;
        while (i < this.classes.length) {
            Class clazz = this.classes[i];
            adapterManager.registerAdapters((IAdapterFactory)this, clazz);
            ++i;
        }
    }
}

