/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.actions;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.graph.AbstractGraphViewPart;

public class ToggleLayoutAction
extends Action {
    final AbstractGraphViewPart view;
    private final String pluginKey;

    public ToggleLayoutAction(AbstractGraphViewPart view, String pluginKey) {
        super("Automatic Layout", 2);
        this.view = view;
        this.pluginKey = pluginKey;
        this.setImageDescriptor(EclipseImages.getImageDescriptor("LAYOUT"));
        this.setDisabledImageDescriptor(EclipseImages.getImageDescriptor("LAYOUT"));
        Preferences prefs = HibernateConsolePlugin.getDefault().getPluginPreferences();
        boolean checked = prefs.getBoolean(pluginKey);
        this.valueChanged(!checked, false);
    }

    public void run() {
        this.valueChanged(!this.isChecked(), true);
    }

    private void valueChanged(boolean value, boolean doStore) {
        this.setChecked(!value);
        this.view.setManualLayout(value);
        this.setToolTipText(value ? "Manual layout active" : "Automatic layout active");
        this.setDescription(value ? "Enable automatic layout" : "Enable manual layout");
        if (doStore) {
            Preferences prefs = HibernateConsolePlugin.getDefault().getPluginPreferences();
            prefs.setValue(this.pluginKey, value);
            HibernateConsolePlugin.getDefault().savePluginPreferences();
        }
    }
}

