/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.hibernate.cfg.Configuration;
import org.hibernate.eclipse.graph.model.PersistentClassViewAdapter;
import org.hibernate.mapping.PersistentClass;

public class ConfigurationViewAdapter
extends Observable {
    private final Configuration cfg;
    private Map persistentClasses;
    private List selectedTables;

    public ConfigurationViewAdapter(Configuration cfg) {
        this.cfg = cfg;
    }

    public List getPersistentClasses() {
        if (this.persistentClasses == null) {
            Iterator classMappings = this.cfg.getClassMappings();
            this.persistentClasses = new HashMap();
            while (classMappings.hasNext()) {
                PersistentClass clazz = (PersistentClass)classMappings.next();
                this.persistentClasses.put(clazz.getEntityName(), new PersistentClassViewAdapter(this, clazz));
            }
            for (PersistentClassViewAdapter element : this.persistentClasses.values()) {
                element.getSourceAssociations();
            }
        }
        return new ArrayList(this.persistentClasses.values());
    }

    public PersistentClassViewAdapter getPersistentClassViewAdapter(String associatedEntityName) {
        return (PersistentClassViewAdapter)this.persistentClasses.get(associatedEntityName);
    }

    public List getSelectedTables() {
        return this.selectedTables;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public void setSelectedTables(List tables) {
        this.selectedTables = tables;
    }
}

