/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.parts;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.hibernate.eclipse.graph.anchor.LeftOrRightParentAnchor;
import org.hibernate.eclipse.graph.figures.EditableLabel;
import org.hibernate.eclipse.graph.model.PropertyViewAdapter;
import org.hibernate.mapping.Property;

public class PropertyEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
Observer {
    public PropertyEditPart(PropertyViewAdapter property) {
        this.setModel(property);
    }

    public void activate() {
        ((Observable)this.getModel()).addObserver(this);
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        ((Observable)this.getModel()).deleteObserver(this);
    }

    protected IFigure createFigure() {
        Property property = ((PropertyViewAdapter)this.getModel()).getProperty();
        String label = property.getName();
        EditableLabel propertyLabel = new EditableLabel(label);
        propertyLabel.setIcon(((PropertyViewAdapter)this.getModel()).getImage());
        return propertyLabel;
    }

    protected void createEditPolicies() {
    }

    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    public List getModelSourceConnections() {
        List sc = ((PropertyViewAdapter)this.getModel()).getSourceConnections();
        return sc;
    }

    public List getModelTargetConnections() {
        List tc = ((PropertyViewAdapter)this.getModel()).getTargetConnections();
        return tc;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new LeftOrRightParentAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new LeftOrRightParentAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new LeftOrRightParentAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new LeftOrRightParentAnchor(this.getFigure());
    }

    public void update(Observable o, Object arg) {
        if (arg == "ASSOCIATIONS") {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        }
    }

    public void setSelected(int value) {
        super.setSelected(value);
    }
}

