/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.hqleditor.DisplayStringProposalComparator;
import org.hibernate.eclipse.hqleditor.EclipseHQLCompletionRequestor;
import org.hibernate.eclipse.hqleditor.HQLEditor;
import org.hibernate.eclipse.hqleditor.LoadConsoleCFGCompletionProposal;
import org.hibernate.eclipse.hqleditor.MinimalDiffContextInformationValidator;
import org.hibernate.tool.ide.completion.HQLCodeAssist;
import org.hibernate.tool.ide.completion.IHQLCompletionRequestor;

public class HQLCompletionProcessor
implements IContentAssistProcessor {
    private char[] autoActivationChars = new char[]{'.'};
    protected IContextInformationValidator validator = new MinimalDiffContextInformationValidator(5);
    private final Comparator completionComparator;
    private final HQLEditor editor;
    private String errorMessage;

    public HQLCompletionProcessor(HQLEditor editor) {
        this.editor = editor;
        this.completionComparator = DisplayStringProposalComparator.INSTANCE;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompletionProposal[] result = new ICompletionProposal[]{};
        try {
            IDocument doc = viewer.getDocument();
            ITypedRegion partition = null;
            partition = documentOffset > 0 ? viewer.getDocument().getPartition(documentOffset - 1) : viewer.getDocument().getPartition(documentOffset);
            if (partition != null) {
                result = this.computeProposals(doc, partition.getOffset(), documentOffset, this.editor.getConsoleConfiguration());
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (RuntimeException re) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Error while performing HQL completion", re);
        }
        if (result != null) {
            result = this.sort(result);
        }
        return result;
    }

    ICompletionProposal[] computeProposals(IDocument doc, int lineStart, int currentOffset, ConsoleConfiguration consoleConfiguration) {
        ICompletionProposal[] result = null;
        this.errorMessage = null;
        if (doc != null && currentOffset >= 0) {
            int wordLength;
            ArrayList<LoadConsoleCFGCompletionProposal> proposalList = new ArrayList<LoadConsoleCFGCompletionProposal>();
            String startWord = null;
            int startOffset = this.findNearestWhiteSpace(doc, currentOffset, lineStart);
            startWord = this.getWord(doc, startOffset, wordLength = currentOffset - startOffset);
            if (startWord != null) {
                try {
                    doc.get(0, doc.getLength()).toCharArray();
                }
                catch (BadLocationException badLocationException) {
                    this.errorMessage = "Could not get document contents";
                    return result;
                }
                Configuration configuration = consoleConfiguration != null ? consoleConfiguration.getConfiguration() : null;
                HQLCodeAssist hqlEval = new HQLCodeAssist(configuration);
                EclipseHQLCompletionRequestor eclipseHQLCompletionCollector = new EclipseHQLCompletionRequestor();
                hqlEval.codeComplete(doc.get(), currentOffset, (IHQLCompletionRequestor)eclipseHQLCompletionCollector);
                proposalList.addAll(eclipseHQLCompletionCollector.getCompletionProposals());
                this.errorMessage = eclipseHQLCompletionCollector.getLastErrorMessage();
                if (configuration == null && consoleConfiguration != null) {
                    proposalList.add(new LoadConsoleCFGCompletionProposal(consoleConfiguration));
                }
                if ((result = proposalList.toArray(new ICompletionProposal[proposalList.size()])).length == 0 && this.errorMessage == null) {
                    this.errorMessage = "No HQL completions available.";
                }
            } else {
                this.errorMessage = "No start word found.";
            }
        }
        return result;
    }

    private String getWord(IDocument doc, int startOffset, int wordLength) {
        try {
            return doc.get(startOffset, wordLength);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.validator;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private ICompletionProposal[] sort(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, this.completionComparator);
        return proposals;
    }

    public int findNearestWhiteSpace(IDocument doc, int documentOffset, int offset) {
        boolean loop = true;
        int tmpOffset = documentOffset - 1;
        try {
            while (loop && offset <= tmpOffset) {
                char c = doc.getChar(tmpOffset);
                if (c == '\"' || Character.isWhitespace(c)) {
                    loop = false;
                    continue;
                }
                --tmpOffset;
            }
        }
        catch (BadLocationException badLocationException) {}
        offset = tmpOffset + 1;
        return offset;
    }
}

