/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.AbstractQueryEditor;
import org.hibernate.eclipse.console.views.IQueryParametersPage;
import org.hibernate.eclipse.console.views.QueryParametersPage;
import org.hibernate.eclipse.hqleditor.HQLCodeScanner;
import org.hibernate.eclipse.hqleditor.HQLColors;
import org.hibernate.eclipse.hqleditor.HQLEditorDocumentSetupParticipant;
import org.hibernate.eclipse.hqleditor.HQLSourceViewer;
import org.hibernate.eclipse.hqleditor.HQLSourceViewerConfiguration;

public class HQLEditor
extends AbstractQueryEditor {
    public static final String PLUGIN_NAME = "org.hibernate.eclipse.console";
    public static final String HELP_CONTEXT_ID = "org.hibernate.eclipse.console.hqleditorhelp";
    private HQLCodeScanner fHQLCodeScanner;
    private HQLEditorDocumentSetupParticipant docSetupParticipant;
    private ProjectionSupport fProjectionSupport;

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = this.getResourceBundle();
        TextOperationAction a = new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, "ContentFormat.", (ITextEditor)this, 15);
        this.setAction("ContentFormat", (IAction)a);
    }

    private ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle("org.hibernate.eclipse.console.messages");
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createToolbar(parent);
        super.createPartControl(parent);
        if (this.getSourceViewer() != null) {
            this.getSourceViewer().addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    HQLEditor.this.updateExecButton();
                }
            });
        }
        Control control = parent.getChildren()[1];
        control.setLayoutData((Object)new GridData(1808));
        this.setProjectionSupport(this.createProjectionSupport());
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        viewer.doOperation(19);
        this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_ID);
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        textWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                HQLEditor.this.getSite().getPage().activate((IWorkbenchPart)HQLEditor.this);
            }
        });
        textWidget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                HQLEditor.this.getSite().getPage().activate((IWorkbenchPart)HQLEditor.this);
            }
        });
    }

    protected ProjectionSupport createProjectionSupport() {
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        ProjectionSupport projSupport = new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors());
        projSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projSupport.install();
        return projSupport;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        HQLSourceViewer viewer = new HQLSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        return viewer;
    }

    protected HQLSourceViewerConfiguration createSourceViewerConfiguration() {
        HQLSourceViewerConfiguration config = new HQLSourceViewerConfiguration(this);
        return config;
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        IDocument doc;
        super.doSetInput(input);
        IDocumentProvider docProvider = this.getDocumentProvider();
        if (docProvider != null && (doc = docProvider.getDocument((Object)input)) != null) {
            HQLEditorDocumentSetupParticipant docSetupParticipant = this.getDocumentSetupParticipant();
            docSetupParticipant.setup(doc);
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "ContentAssistProposal");
        this.addAction(menu, "ContentAssistTip");
        this.addAction(menu, "ContentFormat");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "HQLEditor.runAction");
    }

    public Object getAdapter(Class classForWhichAdapterNeeded) {
        ProjectionSupport projSupport;
        Object adapter = null;
        if (IQueryParametersPage.class.equals((Object)classForWhichAdapterNeeded)) {
            return new QueryParametersPage(this);
        }
        if (IContentOutlinePage.class.equals((Object)classForWhichAdapterNeeded)) {
            adapter = null;
        } else if (adapter == null && (projSupport = this.getProjectionSupport()) != null) {
            adapter = projSupport.getAdapter(this.getSourceViewer(), classForWhichAdapterNeeded);
        }
        if (adapter == null) {
            adapter = super.getAdapter(classForWhichAdapterNeeded);
        }
        return adapter;
    }

    public HQLEditorDocumentSetupParticipant getDocumentSetupParticipant() {
        if (this.docSetupParticipant == null) {
            this.docSetupParticipant = new HQLEditorDocumentSetupParticipant();
        }
        return this.docSetupParticipant;
    }

    protected ProjectionSupport getProjectionSupport() {
        return this.fProjectionSupport;
    }

    public HQLCodeScanner getHQLCodeScanner() {
        if (this.fHQLCodeScanner == null) {
            this.fHQLCodeScanner = new HQLCodeScanner(this.getHQLColorProvider());
        }
        return this.fHQLCodeScanner;
    }

    public HQLColors getHQLColorProvider() {
        return new HQLColors();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setSourceViewerConfiguration(this.createSourceViewerConfiguration());
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
    }

    public void setDocumentSetupParticipant(HQLEditorDocumentSetupParticipant docSetupParticipant) {
        this.docSetupParticipant = docSetupParticipant;
    }

    protected void setProjectionSupport(ProjectionSupport projSupport) {
        this.fProjectionSupport = projSupport;
    }

    public ITextViewer getTextViewer() {
        return this.getSourceViewer();
    }

    public void executeQuery(ConsoleConfiguration cfg) {
        cfg.executeHQLQuery(this.getQueryString(), this.getQueryInputModel().getCopyForQuery());
    }

    protected String getConnectedImageFilePath() {
        return "icons/images/hql_editor_connect.gif";
    }
}

