/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;

public class LoadConsoleCFGCompletionProposal
implements ICompletionProposal {
    private ConsoleConfiguration consoleConfiguration;

    public LoadConsoleCFGCompletionProposal(ConsoleConfiguration consoleConfiguration) {
        this.consoleConfiguration = consoleConfiguration;
    }

    public void apply(IDocument document) {
        if (this.consoleConfiguration.getConfiguration() == null) {
            try {
                this.consoleConfiguration.build();
            }
            catch (HibernateException he) {
                HibernateConsolePlugin hibernateConsolePlugin = HibernateConsolePlugin.getDefault();
                HibernateConsolePlugin.getDefault();
                hibernateConsolePlugin.showError(HibernateConsolePlugin.getShell(), "Could not load configuration " + this.consoleConfiguration.getName(), he);
            }
        }
    }

    public String getAdditionalProposalInfo() {
        return "No open console configuration found.\nThis will attempt to open the console configuration\nto enable better code completion.";
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return "Load Console Configuration";
    }

    public Image getImage() {
        return EclipseImages.getImage("images/configuration.gif");
    }

    public Point getSelection(IDocument document) {
        return null;
    }
}

