/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hibernate.eclipse.console.model.impl.ExporterFactory;
import org.hibernate.eclipse.console.model.impl.ExporterProperty;
import org.hibernate.util.StringHelper;

public class AddPropertyDialog
extends TitleAreaDialog {
    private final ExporterFactory ef;
    private ComboViewer propertyCombo;
    private Text value;
    private String propertyName;
    private String propertyValue;

    protected AddPropertyDialog(Shell parentShell, ExporterFactory ef) {
        super(parentShell);
        this.ef = ef;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Add exporter property");
        this.setTitle("Add property to " + this.ef.getExporterDefinition().getDescription());
        Composite control = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(control, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddPropertyDialog.this.updateStatus();
            }
        };
        Label label = new Label(composite, 0);
        label.setText("Name:");
        Combo combo = new Combo(composite, 18436);
        combo.setLayoutData((Object)new GridData(768));
        combo.setFocus();
        combo.addModifyListener(modifyListener);
        this.propertyCombo = new ComboViewer(combo);
        label = new Label(composite, 0);
        label.setText("Value:");
        this.value = new Text(composite, 18432);
        this.value.setLayoutData((Object)new GridData(768));
        this.value.addModifyListener(modifyListener);
        this.initDefaultNames(this.ef, this.propertyCombo);
        return control;
    }

    private void initDefaultNames(ExporterFactory ef2, ComboViewer viewer) {
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
            ExporterFactory localEf;

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.localEf = (ExporterFactory)newInput;
            }

            public void dispose() {
                this.localEf = null;
            }

            public Object[] getElements(Object inputElement) {
                Iterator set = this.localEf.getDefaultExporterProperties().entrySet().iterator();
                ArrayList<ExporterProperty> values = new ArrayList<ExporterProperty>(4);
                while (set.hasNext()) {
                    Map.Entry element = set.next();
                    ExporterProperty exporterProperty = this.localEf.getExporterProperty((String)element.getKey());
                    if (exporterProperty == null) continue;
                    values.add(exporterProperty);
                }
                return values.toArray(new ExporterProperty[values.size()]);
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                ExporterProperty exporterProperty = (ExporterProperty)element;
                return exporterProperty.getDescriptionForLabel();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (AddPropertyDialog.this.value == null) {
                    return;
                }
                IStructuredSelection iss = (IStructuredSelection)event.getSelection();
                if (!iss.isEmpty()) {
                    AddPropertyDialog.this.value.setText(((ExporterProperty)iss.getFirstElement()).getDefaultValue());
                }
            }
        });
        viewer.setInput((Object)this.ef);
        if (viewer.getCombo().getItemCount() > 0) {
            viewer.setSelection((ISelection)new StructuredSelection(viewer.getElementAt(0)));
        }
    }

    void updateStatus() {
        this.getEnteredValues();
        boolean ok = false;
        if (StringHelper.isEmpty((String)this.getPropertyName())) {
            this.setMessage("The property name must be chosen or entered", 3);
        } else if (this.getPropertyName().indexOf(32) >= 0 || this.getPropertyName().indexOf(9) >= 0) {
            this.setMessage("The property name may not contain whitespaces", 3);
        } else if (StringHelper.isEmpty((String)this.getPropertyValue())) {
            this.setMessage("The property value must be non-empty", 3);
        } else {
            if (this.ef.hasLocalValueFor(this.getPropertyName())) {
                this.setMessage("The property " + this.getPropertyName() + " is already set, pressing ok will overwrite the current value", 2);
            } else {
                this.setMessage(null, 3);
            }
            ok = true;
        }
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(ok);
        }
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    void getEnteredValues() {
        if (this.propertyCombo == null) {
            this.propertyName = null;
        } else {
            IStructuredSelection selection = (IStructuredSelection)this.propertyCombo.getSelection();
            if (selection.isEmpty()) {
                this.propertyName = this.propertyCombo.getCombo().getText();
            } else {
                ExporterProperty p = (ExporterProperty)selection.getFirstElement();
                this.propertyName = p.getName();
            }
        }
        this.propertyValue = this.value != null ? this.value.getText() : null;
    }

    protected void okPressed() {
        this.getEnteredValues();
        super.okPressed();
    }

    public void create() {
        super.create();
        this.updateStatus();
    }
}

