/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.launch.ConsoleConfigurationTab;
import org.xml.sax.EntityResolver;

public class ConsoleConfigurationOptionsTab
extends ConsoleConfigurationTab {
    private Text entityResolverClassNameText;
    private Text namingStrategyClassNameText;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        this.createNamingStrategyClassNameEditor(comp);
        this.createEntityResolverClassNameEditor(comp);
    }

    private void createNamingStrategyClassNameEditor(Composite parent) {
        Group group = this.createGroup(parent, "Naming strategy:");
        this.namingStrategyClassNameText = this.createBrowseEditor(parent, group);
        this.createBrowseButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationOptionsTab.this.handleNamingStrategyBrowse();
            }
        });
    }

    private void createEntityResolverClassNameEditor(Composite parent) {
        Group group = this.createGroup(parent, "Entity resolver:");
        this.entityResolverClassNameText = this.createBrowseEditor(parent, group);
        this.createBrowseButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationOptionsTab.this.handleEntityResolverBrowse();
            }
        });
    }

    public String getName() {
        return "Options";
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_OBJS_COMMON_TAB");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.namingStrategyClassNameText.setText(configuration.getAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", ""));
            this.entityResolverClassNameText.setText(configuration.getAttribute("org.hibernate.eclipse.launchENTITY_RESOLVER", ""));
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", this.nonEmptyTrimOrNull(this.namingStrategyClassNameText));
        configuration.setAttribute("org.hibernate.eclipse.launchENTITY_RESOLVER", this.nonEmptyTrimOrNull(this.entityResolverClassNameText));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void handleEntityResolverBrowse() {
        String string = DialogSelectionHelper.chooseImplementation(EntityResolver.class.getName(), this.entityResolverClassNameText.getText(), "Select entity resolver class", this.getShell());
        if (string != null) {
            this.entityResolverClassNameText.setText(string);
        }
    }

    private void handleNamingStrategyBrowse() {
        String string = DialogSelectionHelper.chooseImplementation(NamingStrategy.class.getName(), this.namingStrategyClassNameText.getText(), "Select naming strategy class", this.getShell());
        if (string != null) {
            this.namingStrategyClassNameText.setText(string);
        }
    }
}

