/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;

public class PathHelper {
    public static String getLocationAsStringPath(String path) {
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource member = PathHelper.findMember(root, path);
        if (member == null) {
            if (new File(path).exists()) {
                return path;
            }
            return null;
        }
        return PathHelper.getLocation(member).toOSString();
    }

    public static IResource findMember(IWorkspaceRoot root, String path) {
        IContainer[] findContainersForLocation;
        Path pathOrNull = PathHelper.pathOrNull(path);
        if (pathOrNull == null) {
            return null;
        }
        IResource findMember = root.findMember((IPath)pathOrNull);
        if (findMember == null && (findContainersForLocation = root.findContainersForLocation((IPath)pathOrNull)).length > 0) {
            findMember = findContainersForLocation[0];
        }
        return findMember;
    }

    public static IPath getLocation(IResource resource) {
        if (resource.getRawLocation() == null) {
            return resource.getLocation();
        }
        return resource.getRawLocation();
    }

    private static String resolve(String expression) {
        if (expression == null) {
            return null;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return variableManager.performStringSubstitution(expression, false);
        }
        catch (CoreException coreException) {
            return expression;
        }
    }

    public static Path pathOrNull(String p) {
        return PathHelper.pathOrNull(p, false);
    }

    public static Path pathOrNull(String p, boolean resolveVariables) {
        if (resolveVariables && p != null) {
            p = PathHelper.resolve(p);
        }
        if (p == null || p.trim().length() == 0) {
            return null;
        }
        return new Path(p);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkDirectory(String strpath, String name, boolean checkFilesystem) {
        if (strpath.indexOf("${") >= 0) {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                manager.validateStringVariables(strpath);
            }
            catch (CoreException e) {
                return String.valueOf(name) + " has invalid variable references [" + e.getMessage() + "]";
            }
        }
        Path path = PathHelper.pathOrNull(PathHelper.resolve(strpath));
        if (checkFilesystem && path != null && new File(path.toOSString()).exists()) {
            return null;
        }
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (res == null) return String.valueOf(name) + " does not exist [" + path + "]";
        int resType = res.getType();
        if (resType != 4 && resType != 2) return String.valueOf(name) + " has to be a folder or project [" + path + "]";
        IProject proj = res.getProject();
        if (proj.isOpen()) return null;
        return "Project for " + name + " is closed [" + path + "]";
    }
}

