/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.NDC;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceMBean;
import org.jboss.util.Classes;

public class ServiceMBeanSupport
extends JBossNotificationBroadcasterSupport
implements ServiceMBean,
MBeanRegistration {
    public static final String[] SERVICE_CONTROLLER_SIG = new String[]{ObjectName.class.getName()};
    protected Logger log;
    protected MBeanServer server;
    protected ObjectName serviceName;
    private int state = 7;
    private SynchronizedLong sequenceNumber = new SynchronizedLong(0L);
    private boolean isJBossInternalLifecycleExposed = false;

    public ServiceMBeanSupport() {
        this.log = Logger.getLogger((String)this.getClass().getName());
        this.log.trace((Object)"Constructing");
    }

    public ServiceMBeanSupport(Class type) {
        this(type.getName());
    }

    public ServiceMBeanSupport(String category) {
        this(Logger.getLogger((String)category));
    }

    public ServiceMBeanSupport(Logger log) {
        this.log = log;
        log.trace((Object)"Constructing");
    }

    public String getName() {
        return Classes.stripPackageName((String)this.log.getName());
    }

    public ObjectName getServiceName() {
        return this.serviceName;
    }

    public MBeanServer getServer() {
        return this.server;
    }

    public int getState() {
        return this.state;
    }

    public String getStateString() {
        return states[this.state];
    }

    public Logger getLog() {
        return this.log;
    }

    public void create() throws Exception {
        if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
            this.server.invoke(ServiceController.OBJECT_NAME, "create", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
        } else {
            this.jbossInternalCreate();
        }
    }

    public void start() throws Exception {
        if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
            this.server.invoke(ServiceController.OBJECT_NAME, "start", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
        } else {
            this.jbossInternalStart();
        }
    }

    public void stop() {
        try {
            if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
                this.server.invoke(ServiceController.OBJECT_NAME, "stop", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
            } else {
                this.jbossInternalStop();
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Error in stop " + this.jbossInternalDescription()), t);
        }
    }

    public void destroy() {
        try {
            if (this.serviceName != null && this.isJBossInternalLifecycleExposed) {
                this.server.invoke(ServiceController.OBJECT_NAME, "destroy", new Object[]{this.serviceName}, SERVICE_CONTROLLER_SIG);
            } else {
                this.jbossInternalDestroy();
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Error in destroy " + this.jbossInternalDescription()), t);
        }
    }

    protected String jbossInternalDescription() {
        if (this.serviceName != null) {
            return this.serviceName.toString();
        }
        return this.getName();
    }

    public void jbossInternalLifecycle(String method) throws Exception {
        if (method == null) {
            throw new IllegalArgumentException("Null method name");
        }
        if (method.equals("create")) {
            this.jbossInternalCreate();
        } else if (method.equals("start")) {
            this.jbossInternalStart();
        } else if (method.equals("stop")) {
            this.jbossInternalStop();
        } else if (method.equals("destroy")) {
            this.jbossInternalDestroy();
        } else {
            throw new IllegalArgumentException("Unknown lifecyle method " + method);
        }
    }

    protected void jbossInternalCreate() throws Exception {
        NDC.push((String)this.getName());
        this.log.debug((Object)("Creating " + this.jbossInternalDescription()));
        try {
            this.createService();
            this.state = 6;
        }
        catch (Exception e) {
            this.log.error((Object)("Initialization failed " + this.jbossInternalDescription()), (Throwable)e);
            throw e;
        }
        finally {
            NDC.pop();
            NDC.remove();
        }
        this.log.debug((Object)("Created " + this.jbossInternalDescription()));
    }

    public void jbossInternalStart() throws Exception {
        if (this.state == 2 || this.state == 3) {
            return;
        }
        this.state = 2;
        long now = System.currentTimeMillis();
        AttributeChangeNotification stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " starting", "State", "java.lang.Integer", new Integer(0), new Integer(2));
        this.sendNotification(stateChange);
        this.log.debug((Object)("Starting " + this.jbossInternalDescription()));
        NDC.push((String)this.getName());
        try {
            this.startService();
        }
        catch (Exception e) {
            this.state = 4;
            now = System.currentTimeMillis();
            stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " failed", "State", "java.lang.Integer", new Integer(2), new Integer(4));
            stateChange.setUserData(e);
            this.sendNotification(stateChange);
            this.log.error((Object)("Starting failed " + this.jbossInternalDescription()), (Throwable)e);
            throw e;
        }
        finally {
            NDC.pop();
            NDC.remove();
        }
        this.state = 3;
        now = System.currentTimeMillis();
        stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " started", "State", "java.lang.Integer", new Integer(2), new Integer(3));
        this.sendNotification(stateChange);
        this.log.debug((Object)("Started " + this.jbossInternalDescription()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jbossInternalStop() {
        if (this.state != 3) {
            return;
        }
        this.state = 1;
        long now = System.currentTimeMillis();
        AttributeChangeNotification stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " stopping", "State", "java.lang.Integer", new Integer(3), new Integer(1));
        this.sendNotification(stateChange);
        this.log.debug((Object)("Stopping " + this.jbossInternalDescription()));
        NDC.push((String)this.getName());
        try {
            this.stopService();
        }
        catch (Throwable e) {
            this.state = 4;
            now = System.currentTimeMillis();
            stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " failed", "State", "java.lang.Integer", new Integer(1), new Integer(4));
            stateChange.setUserData(e);
            this.sendNotification(stateChange);
            this.log.error((Object)("Stopping failed " + this.jbossInternalDescription()), e);
            return;
        }
        finally {
            NDC.pop();
            NDC.remove();
        }
        this.state = 0;
        now = System.currentTimeMillis();
        stateChange = new AttributeChangeNotification(this, this.getNextNotificationSequenceNumber(), now, this.getName() + " stopped", "State", "java.lang.Integer", new Integer(1), new Integer(0));
        this.sendNotification(stateChange);
        this.log.debug((Object)("Stopped " + this.jbossInternalDescription()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jbossInternalDestroy() {
        if (this.state == 5) {
            return;
        }
        if (this.state != 0) {
            this.stop();
        }
        this.log.debug((Object)("Destroying " + this.jbossInternalDescription()));
        NDC.push((String)this.getName());
        try {
            this.destroyService();
        }
        catch (Throwable t) {
            this.log.error((Object)("Destroying failed " + this.jbossInternalDescription()), t);
        }
        finally {
            NDC.pop();
            NDC.remove();
        }
        this.state = 5;
        this.log.debug((Object)("Destroyed " + this.jbossInternalDescription()));
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.serviceName = this.getObjectName(server, name);
        return this.serviceName;
    }

    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            this.log.info((Object)"Registration is not done -> stop");
            this.stop();
        } else {
            this.state = 8;
            try {
                MBeanInfo info = this.server.getMBeanInfo(this.serviceName);
                MBeanOperationInfo[] ops = info.getOperations();
                for (int i = 0; i < ops.length; ++i) {
                    if (ops[i] == null || !"jbossInternalLifecycle".equals(ops[i].getName())) continue;
                    this.isJBossInternalLifecycleExposed = true;
                    break;
                }
            }
            catch (Throwable t) {
                this.log.warn((Object)("Unexcepted error accessing MBeanInfo for " + this.serviceName), t);
            }
        }
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        this.server = null;
        this.serviceName = null;
        this.state = 7;
    }

    protected long getNextNotificationSequenceNumber() {
        return this.sequenceNumber.increment();
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        return name;
    }

    protected void createService() throws Exception {
    }

    protected void startService() throws Exception {
    }

    protected void stopService() throws Exception {
    }

    protected void destroyService() throws Exception {
    }
}

