/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.TreeCacheListener;
import org.jboss.cache.aop.TreeCacheAop;
import org.jgroups.View;

class TreeCacheAopGui
extends JFrame
implements WindowListener,
TreeCacheListener,
TreeSelectionListener,
TableModelListener {
    TreeCacheAop cache_;
    DefaultTreeModel tree_model = null;
    Log log = LogFactory.getLog(this.getClass());
    JTree jtree = null;
    DefaultTableModel table_model = new DefaultTableModel();
    JTable table = new JTable(this.table_model);
    MyNode root = new MyNode(SEP, Fqn.fromString(SEP));
    String props = null;
    String selected_node = null;
    JPanel tablePanel = null;
    JMenu operationsMenu = null;
    JPopupMenu operationsPopup = null;
    JMenuBar menubar = null;
    boolean use_system_exit = false;
    static String SEP = "/";
    private static final int KEY_COL_WIDTH = 20;
    private static final int VAL_COL_WIDTH = 300;
    final String STRING = (class$java$lang$String == null ? (class$java$lang$String = TreeCacheAopGui.class$("java.lang.String")) : class$java$lang$String).getName();
    final String MAP = (class$java$util$Map == null ? (class$java$util$Map = TreeCacheAopGui.class$("java.util.Map")) : class$java$util$Map).getName();
    final String OBJECT = (class$java$lang$Object == null ? (class$java$lang$Object = TreeCacheAopGui.class$("java.lang.Object")) : class$java$lang$Object).getName();
    String currentNodeSelected = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Object;

    public TreeCacheAopGui(TreeCacheAop cache) throws Exception {
        this.cache_ = cache;
        this.cache_.addTreeCacheListener(this);
        this.addNotify();
        this.setTitle("TreeCacheAopGui: mbr=" + this.getLocalAddress());
        this.tree_model = new DefaultTreeModel(this.root);
        this.jtree = new JTree(this.tree_model);
        this.jtree.setDoubleBuffered(true);
        this.jtree.getSelectionModel().setSelectionMode(1);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JScrollPane scroll_pane = new JScrollPane(this.jtree);
        panel.add((Component)scroll_pane, "Center");
        this.populateTree();
        this.getContentPane().add((Component)panel, "Center");
        this.addWindowListener(this);
        this.table_model.setColumnIdentifiers(new String[]{"Name", "Value"});
        this.table_model.addTableModelListener(this);
        this.setTableColumnWidths();
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)this.table.getTableHeader(), "North");
        this.tablePanel.add((Component)this.table, "Center");
        this.getContentPane().add((Component)this.tablePanel, "South");
        this.jtree.addTreeSelectionListener(this);
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int selRow = TreeCacheAopGui.this.jtree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = TreeCacheAopGui.this.jtree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    TreeCacheAopGui.this.selected_node = TreeCacheAopGui.this.makeFQN(selPath.getPath());
                    TreeCacheAopGui.this.jtree.setSelectionPath(selPath);
                    if (e.getModifiers() == 4) {
                        TreeCacheAopGui.this.operationsPopup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        };
        this.jtree.addMouseListener(ml);
        this.createMenus();
        this.setLocation(50, 50);
        this.setSize(this.getInsets().left + this.getInsets().right + 485, this.getInsets().top + this.getInsets().bottom + 367);
        this.init();
        this.setVisible(true);
    }

    void setSystemExit(boolean flag) {
        this.use_system_exit = flag;
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    public void tableChanged(TableModelEvent evt) {
        if (evt.getType() == 0) {
            int row = evt.getFirstRow();
            int col = evt.getColumn();
            if (col == 0) {
                String key = (String)this.table_model.getValueAt(row, col);
                String val = (String)this.table_model.getValueAt(row, col + 1);
                if (key != null && val != null) {
                    try {
                        this.cache_.put(this.selected_node, (Object)key, (Object)val);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String key = (String)this.table_model.getValueAt(row, col - 1);
                String val = (String)this.table.getValueAt(row, col);
                if (key != null && val != null) {
                    this.put(this.selected_node, key, val);
                }
            }
        }
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        String fqn = SEP;
        Map data = null;
        for (int i = 0; i < path.getPathCount(); ++i) {
            String component_name = ((MyNode)path.getPathComponent((int)i)).name;
            if (component_name.equals(SEP)) continue;
            fqn = fqn.equals(SEP) ? fqn + component_name : fqn + SEP + component_name;
        }
        data = this.getData(fqn);
        System.out.println("valueChanged(): fqn: " + fqn + " data: " + data);
        if (data != null) {
            this.getContentPane().add((Component)this.tablePanel, "South");
            this.populateTable(data);
            this.validate();
        } else {
            this.clearTable();
            this.getContentPane().remove(this.tablePanel);
            this.validate();
        }
    }

    public void nodeCreated(Fqn fqn) {
        MyNode n = this.root.add(fqn);
        if (n != null) {
            MyNode p = (MyNode)n.getParent();
            this.tree_model.reload(p);
            this.jtree.scrollPathToVisible(new TreePath(n.getPath()));
        }
    }

    public void nodeRemoved(Fqn fqn) {
        MyNode n = this.root.findNode(fqn.toString());
        if (n != null) {
            n.removeAllChildren();
            TreeNode par = n.getParent();
            n.removeFromParent();
            this.tree_model.reload(par);
        }
    }

    public void nodeLoaded(Fqn fqn) {
        this.nodeCreated(fqn);
    }

    public void nodeEvicted(Fqn fqn) {
        this.nodeRemoved(fqn);
    }

    public void nodeModified(Fqn fqn) {
        if (this.currentNodeSelected != null && !this.currentNodeSelected.equals(fqn.toString())) {
            return;
        }
        Map data = this.getData(fqn.toString());
        this.populateTable(data);
    }

    public void nodeVisited(Fqn fqn) {
    }

    public void cacheStarted(TreeCache cache) {
    }

    public void cacheStopped(TreeCache cache) {
    }

    public void viewChange(final View new_view) {
        new Thread(){

            public void run() {
                Vector mbrship;
                if (new_view != null && (mbrship = new_view.getMembers()) != null) {
                    TreeCacheAopGui.this._put(SEP, "members", mbrship);
                    TreeCacheAopGui.this._put(SEP, "coordinator", mbrship.firstElement());
                }
            }
        }.start();
    }

    public void run() {
    }

    void init() {
        Vector mbrship = null;
        this.addGuiNode(SEP);
        Vector vector = mbrship = this.getMembers() != null ? (Vector)this.getMembers().clone() : null;
        if (mbrship != null && mbrship.size() > 0) {
            this._put(SEP, "members", mbrship);
            this._put(SEP, "coordinator", mbrship.firstElement());
        }
    }

    private void populateTree() {
        this.addGuiNode(SEP);
    }

    void addGuiNode(String fqn) {
        if (fqn == null) {
            return;
        }
        this.root.add(Fqn.fromString(fqn));
        Set children = this.getChildrenNames(fqn);
        if (children != null) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                String child_name = (String)it.next();
                this.addGuiNode(fqn + SEP + child_name);
            }
        }
    }

    String makeFQN(Object[] path) {
        String tmp_name;
        StringBuffer sb = new StringBuffer("");
        if (path == null) {
            return null;
        }
        for (int i = 0; i < path.length; ++i) {
            tmp_name = ((MyNode)path[i]).name;
            if (tmp_name.equals(SEP)) continue;
            sb.append(SEP + tmp_name);
        }
        tmp_name = sb.toString();
        if (tmp_name.length() == 0) {
            return SEP;
        }
        return tmp_name;
    }

    void clearTable() {
        int num_rows = this.table.getRowCount();
        if (num_rows > 0) {
            for (int i = 0; i < num_rows; ++i) {
                this.table_model.removeRow(0);
            }
            this.table_model.fireTableRowsDeleted(0, num_rows - 1);
            this.repaint();
        }
    }

    void populateTable(Map data) {
        String strval = "<null>";
        int num_rows = 0;
        if (data == null) {
            return;
        }
        num_rows = data.size();
        this.clearTable();
        if (num_rows > 0) {
            Iterator it = data.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (val != null) {
                    strval = val.toString();
                }
                this.table_model.addRow(new Object[]{key, strval});
            }
            this.table_model.fireTableRowsInserted(0, num_rows - 1);
            this.validate();
        }
    }

    private void setTableColumnWidths() {
        this.table.sizeColumnsToFit(1);
        TableColumn column = null;
        column = this.table.getColumnModel().getColumn(0);
        column.setMinWidth(20);
        column.setPreferredWidth(20);
        column = this.table.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
    }

    private void createMenus() {
        this.menubar = new JMenuBar();
        this.operationsMenu = new JMenu("Operations");
        AddNodeAction addNode = new AddNodeAction();
        addNode.putValue("Name", "Add to this node");
        RemoveNodeAction removeNode = new RemoveNodeAction();
        removeNode.putValue("Name", "Remove this node");
        AddModifyDataForNodeAction addModAction = new AddModifyDataForNodeAction();
        addModAction.putValue("Name", "Add/Modify data");
        PrintLockInfoAction print_locks = new PrintLockInfoAction();
        print_locks.putValue("Name", "Print lock information (stdout)");
        ReleaseAllLocksAction release_locks = new ReleaseAllLocksAction();
        release_locks.putValue("Name", "Release all locks");
        ExitAction exitAction = new ExitAction();
        exitAction.putValue("Name", "Exit");
        this.operationsMenu.add(addNode);
        this.operationsMenu.add(removeNode);
        this.operationsMenu.add(addModAction);
        this.operationsMenu.add(print_locks);
        this.operationsMenu.add(release_locks);
        this.operationsMenu.add(exitAction);
        this.menubar.add(this.operationsMenu);
        this.setJMenuBar(this.menubar);
        this.operationsPopup = new JPopupMenu();
        this.operationsPopup.add(addNode);
        this.operationsPopup.add(removeNode);
        this.operationsPopup.add(addModAction);
    }

    Object getLocalAddress() {
        try {
            return this.cache_.getLocalAddress();
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheAopGui.getLocalAddress(): " + t));
            return null;
        }
    }

    Map getData(String fqn) {
        if (fqn == null) {
            return null;
        }
        this.currentNodeSelected = fqn;
        MyNode node = this.root.findNode(fqn);
        if (node == null) {
            return null;
        }
        Set keys = this.getKeys(node.getFqn());
        if (keys == null) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            Object value = this.get(node.getFqn(), key);
            if (value == null) continue;
            data.put(key, value);
        }
        return data;
    }

    void put(String fqn, Map m) {
        try {
            this.cache_.put(fqn, m);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheAopGui.put(): " + t));
        }
    }

    private void put(String fqn, String key, Object value) {
        try {
            this.cache_.put(fqn, (Object)key, value);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheAopGui.put(): " + t));
        }
    }

    void _put(String fqn, String key, Object value) {
        try {
            this.cache_._put(null, fqn, (Object)key, value, false);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheAopGui._put(): " + t));
        }
    }

    Set getKeys(Fqn fqn) {
        try {
            return this.cache_.getKeys(fqn);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.log.error((Object)("TreeCacheAopGui.getKeys(): " + t));
            return null;
        }
    }

    Object get(Fqn fqn, String key) {
        try {
            return this.cache_.get(fqn, (Object)key);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheAopGui.get(): " + t));
            return null;
        }
    }

    Set getChildrenNames(String fqn) {
        try {
            return this.cache_.getChildrenNames(fqn);
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheAopGui.getChildrenNames(): " + t));
            return null;
        }
    }

    Vector getMembers() {
        try {
            return this.cache_.getMembers();
        }
        catch (Throwable t) {
            this.log.error((Object)("TreeCacheAopGui.getMembers(): " + t));
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyNode
    extends DefaultMutableTreeNode {
        String name = "<unnamed>";
        Fqn fqn;

        MyNode(String name, Fqn fqn) {
            this.fqn = fqn;
            this.name = name;
        }

        public Fqn getFqn() {
            return this.fqn;
        }

        public MyNode add(Fqn fqn) {
            MyNode ret = null;
            if (fqn == null) {
                return null;
            }
            MyNode curr = this;
            String fqnStr = fqn.toString();
            StringTokenizer tok = new StringTokenizer(fqnStr, SEP);
            int i = 0;
            while (tok.hasMoreTokens()) {
                String child_name = tok.nextToken();
                MyNode n = curr.findChild(child_name);
                if (n == null) {
                    n = new MyNode(child_name, fqn.getFqnChild(i + 1));
                    if (ret == null) {
                        ret = n;
                    }
                    curr.add(n);
                }
                curr = n;
                ++i;
            }
            return ret;
        }

        public void remove(String fqn) {
            this.removeFromParent();
        }

        MyNode findNode(String fqn) {
            if (fqn == null) {
                return null;
            }
            MyNode curr = this;
            StringTokenizer tok = new StringTokenizer(fqn, SEP);
            while (tok.hasMoreTokens()) {
                String child_name = tok.nextToken();
                MyNode n = curr.findChild(child_name);
                if (n == null) {
                    return null;
                }
                curr = n;
            }
            return curr;
        }

        MyNode findChild(String relative_name) {
            if (relative_name == null || this.getChildCount() == 0) {
                return null;
            }
            for (int i = 0; i < this.getChildCount(); ++i) {
                MyNode child = (MyNode)this.getChildAt(i);
                if (child.name == null || !child.name.equals(relative_name)) continue;
                return child;
            }
            return null;
        }

        String print(int indent) {
            int i;
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < indent; ++i) {
                sb.append(" ");
            }
            if (!this.isRoot()) {
                if (this.name == null) {
                    sb.append("/<unnamed>");
                } else {
                    sb.append(SEP + this.name);
                }
            }
            sb.append("\n");
            if (this.getChildCount() > 0) {
                indent = this.isRoot() ? 0 : (indent += 4);
                for (i = 0; i < this.getChildCount(); ++i) {
                    sb.append(((MyNode)this.getChildAt(i)).print(indent));
                }
            }
            return sb.toString();
        }

        public String toString() {
            return this.name;
        }
    }

    class AddModifyDataForNodeAction
    extends AbstractAction {
        AddModifyDataForNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            HashMap<String, String> data = TreeCacheAopGui.this.getData(TreeCacheAopGui.this.selected_node);
            if (data == null) {
                TreeCacheAopGui.this.clearTable();
                data = new HashMap<String, String>();
                data.put("Add Key", "Add Value");
            }
            TreeCacheAopGui.this.populateTable(data);
            TreeCacheAopGui.this.getContentPane().add((Component)TreeCacheAopGui.this.tablePanel, "South");
            TreeCacheAopGui.this.validate();
        }
    }

    class RemoveNodeAction
    extends AbstractAction {
        RemoveNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TreeCacheAopGui.this.cache_.remove(TreeCacheAopGui.this.selected_node);
            }
            catch (Throwable t) {
                TreeCacheAopGui.this.log.error((Object)("RemoveNodeAction.actionPerformed(): " + t));
            }
        }
    }

    class ReleaseAllLocksAction
    extends AbstractAction {
        ReleaseAllLocksAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TreeCacheAopGui.this.cache_.releaseAllLocks("/");
        }
    }

    class PrintLockInfoAction
    extends AbstractAction {
        PrintLockInfoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("\n*** lock information ****\n" + TreeCacheAopGui.this.cache_.printLockInfo());
        }
    }

    class AddNodeAction
    extends AbstractAction {
        AddNodeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JTextField fqnTextField = new JTextField();
            if (TreeCacheAopGui.this.selected_node != null) {
                fqnTextField.setText(TreeCacheAopGui.this.selected_node);
            }
            Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
            String btnString1 = "OK";
            String btnString2 = "Cancel";
            Object[] options = new Object[]{"OK", "Cancel"};
            int userChoice = JOptionPane.showOptionDialog(null, information, "Add DataNode", 0, -1, null, options, options[0]);
            if (userChoice == 0) {
                String userInput = fqnTextField.getText();
                TreeCacheAopGui.this.put(userInput, null);
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        ExitAction() {
        }

        public void actionPerformed(ActionEvent e) {
            TreeCacheAopGui.this.dispose();
            System.exit(0);
        }
    }
}

