/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.eviction.BaseEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.eviction.LRUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.Region;

public class LRUAlgorithm
extends BaseEvictionAlgorithm
implements EvictionAlgorithm {
    private static final Log log = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$LRUAlgorithm == null ? (class$org$jboss$cache$eviction$LRUAlgorithm = LRUAlgorithm.class$("org.jboss.cache.eviction.LRUAlgorithm")) : class$org$jboss$cache$eviction$LRUAlgorithm));
    static /* synthetic */ Class class$org$jboss$cache$eviction$LRUAlgorithm;

    protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
        return new LRUQueue();
    }

    protected boolean shouldEvictNode(NodeEntry entry) {
        long currentTime = System.currentTimeMillis();
        LRUConfiguration config = (LRUConfiguration)this.region.getEvictionConfiguration();
        if (config.getTimeToLiveSeconds() == 0 && config.getMaxAgeSeconds() == 0) {
            return false;
        }
        if (config.getTimeToLiveSeconds() != 0) {
            long idleTime = currentTime - entry.getModifiedTimeStamp();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Node " + entry.getFqn().toString() + " has been idle for " + idleTime + "ms"));
            }
            if (idleTime >= (long)(config.getTimeToLiveSeconds() * 1000)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Node " + entry.getFqn().toString() + " should be evicted because of idle time"));
                }
                return true;
            }
        }
        if (config.getMaxAgeSeconds() != 0) {
            long objectLifeTime = currentTime - entry.getCreationTimeStamp();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Node " + entry.getFqn().toString() + " has been alive for " + objectLifeTime + "ms"));
            }
            if (objectLifeTime >= (long)(config.getMaxAgeSeconds() * 1000)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Node " + entry.getFqn().toString() + " should be evicted because of max age"));
                }
                return true;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Node " + entry.getFqn().toString() + " should not be evicted"));
        }
        return false;
    }

    protected void prune() throws EvictionException {
        NodeEntry ne;
        LRUQueue lruQueue = (LRUQueue)this.evictionQueue;
        while ((ne = lruQueue.getFirstLRUNodeEntry()) != null && this.shouldEvictNode(ne)) {
            this.evict(ne);
        }
        while ((ne = lruQueue.getFirstMaxAgeNodeEntry()) != null && this.shouldEvictNode(ne)) {
            this.evict(ne);
        }
        int maxNodes = this.getConfiguration().getMaxNodes();
        if (maxNodes <= 0) {
            return;
        }
        while (this.evictionQueue.size() > maxNodes) {
            ne = this.evictionQueue.getFirstNodeEntry();
            this.evict(ne);
        }
    }

    private LRUConfiguration getConfiguration() {
        return (LRUConfiguration)this.region.getEvictionConfiguration();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

